/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Gamma;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.recommender.ProbabilisticGraphicalRecommender;

public class URPRecommender
extends ProbabilisticGraphicalRecommender {
    private double preRMSE;
    private DenseMatrix userTopicNum;
    private DenseVector userNum;
    private DenseMatrix topicItemNum;
    private DenseMatrix userTopicProbs;
    private DenseMatrix userTopicSumProbs;
    private DenseVector alpha;
    private DenseVector beta;
    protected Table<Integer, Integer, Integer> topics;
    protected int numTopics;
    protected int numRatingLevels;
    private int[][][] topicItemRatingNum;
    private double[][][] topicItemRatingSumProbs;
    protected double[][][] topicItemRatingProbs;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.numTopics = this.conf.getInt("rec.pgm.number", 10);
        this.numRatingLevels = this.trainMatrix.getValueSet().size();
        this.userTopicSumProbs = new DenseMatrix(this.numUsers, this.numTopics);
        this.topicItemRatingSumProbs = new double[this.numTopics][this.numItems][this.numRatingLevels];
        this.userTopicNum = new DenseMatrix(this.numUsers, this.numTopics);
        this.userNum = new DenseVector(this.numUsers);
        this.topicItemRatingNum = new int[this.numTopics][this.numItems][this.numRatingLevels];
        this.topicItemNum = new DenseMatrix(this.numTopics, this.numItems);
        this.alpha = new DenseVector(this.numTopics);
        double initAlpha = this.conf.getDouble("rec.pgm.bucm.alpha", 1.0 / (double)this.numTopics);
        this.alpha.setAll(initAlpha);
        this.beta = new DenseVector(this.numRatingLevels);
        double initBeta = this.conf.getDouble("rec.pgm.bucm.beta", 1.0 / (double)this.numTopics);
        this.beta.setAll(initBeta);
        this.topics = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = (int)(Randoms.uniform() * (double)this.numTopics);
            this.topics.put(u, i, t);
            this.userTopicNum.add(u, t, 1.0);
            this.userNum.add(u, 1.0);
            int[] nArray = this.topicItemRatingNum[t][i];
            int n = r;
            nArray[n] = nArray[n] + 1;
            this.topicItemNum.add(t, i, 1.0);
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int k;
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = this.topics.get(u, i);
            this.userTopicNum.add(u, t, -1.0);
            this.userNum.add(u, -1.0);
            int[] nArray = this.topicItemRatingNum[t][i];
            int n = r;
            nArray[n] = nArray[n] - 1;
            this.topicItemNum.add(t, i, -1.0);
            double[] p = new double[this.numTopics];
            for (k = 0; k < this.numTopics; ++k) {
                p[k] = (this.userTopicNum.get(u, k) + this.alpha.get(k)) / (this.userNum.get(u) + sumAlpha) * ((double)this.topicItemRatingNum[k][i][r] + this.beta.get(r)) / (this.topicItemNum.get(k, i) + sumBeta);
            }
            for (k = 1; k < p.length; ++k) {
                int n2 = k;
                p[n2] = p[n2] + p[k - 1];
            }
            double rand = Randoms.uniform() * p[this.numTopics - 1];
            for (t = 0; t < p.length && !(rand < p[t]); ++t) {
            }
            this.topics.put(u, i, t);
            this.userTopicNum.add(u, t, 1.0);
            this.userNum.add(u, 1.0);
            int[] nArray2 = this.topicItemRatingNum[t][i];
            int n3 = r;
            nArray2[n3] = nArray2[n3] + 1;
            this.topicItemNum.add(t, i, 1.0);
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (int k = 0; k < this.numTopics; ++k) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                numerator += Gamma.digamma(this.userTopicNum.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.userNum.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
            }
            if (numerator == 0.0) continue;
            this.alpha.set(k, ak * (numerator / denominator));
        }
        for (int r = 0; r < this.numRatingLevels; ++r) {
            double br = this.beta.get(r);
            numerator = 0.0;
            denominator = 0.0;
            for (int i = 0; i < this.numItems; ++i) {
                for (int k = 0; k < this.numTopics; ++k) {
                    numerator += Gamma.digamma((double)this.topicItemRatingNum[k][i][r] + br) - Gamma.digamma(br);
                    denominator += Gamma.digamma(this.topicItemNum.get(k, i) + sumBeta) - Gamma.digamma(sumBeta);
                }
            }
            if (numerator == 0.0) continue;
            this.beta.set(r, br * (numerator / denominator));
        }
    }

    @Override
    protected void readoutParams() {
        double val = 0.0;
        double sumAlpha = this.alpha.sum();
        for (int u = 0; u < this.numUsers; ++u) {
            for (int k = 0; k < this.numTopics; ++k) {
                val = (this.userTopicNum.get(u, k) + this.alpha.get(k)) / (this.userNum.get(u) + sumAlpha);
                this.userTopicSumProbs.add(u, k, val);
            }
        }
        double sumBeta = this.beta.sum();
        for (int k = 0; k < this.numTopics; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                int r = 0;
                while (r < this.numRatingLevels) {
                    val = ((double)this.topicItemRatingNum[k][i][r] + this.beta.get(r)) / (this.topicItemNum.get(k, i) + sumBeta);
                    double[] dArray = this.topicItemRatingSumProbs[k][i];
                    int n = r++;
                    dArray[n] = dArray[n] + val;
                }
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.userTopicProbs = this.userTopicSumProbs.scale(1.0 / (double)this.numStats);
        this.topicItemRatingProbs = new double[this.numTopics][this.numItems][this.numRatingLevels];
        for (int k = 0; k < this.numTopics; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                for (int r = 0; r < this.numRatingLevels; ++r) {
                    this.topicItemRatingProbs[k][i][r] = this.topicItemRatingSumProbs[k][i][r] / (double)this.numStats;
                }
            }
        }
    }

    @Override
    protected boolean isConverged(int iter) {
        if (this.validMatrix == null) {
            return false;
        }
        this.estimateParams();
        int numCount = 0;
        double sum = 0.0;
        for (MatrixEntry me : this.validMatrix) {
            double rate = me.get();
            int u = me.row();
            int j = me.column();
            double pred = 0.0;
            try {
                pred = this.predict(u, j, true);
            }
            catch (LibrecException e) {
                e.printStackTrace();
            }
            if (Double.isNaN(pred)) continue;
            double err = rate - pred;
            sum += err * err;
            ++numCount;
        }
        double RMSE = Math.sqrt(sum / (double)numCount);
        double delta = RMSE - this.preRMSE;
        if (this.numStats > 1 && delta > 0.0) {
            return true;
        }
        this.preRMSE = RMSE;
        return false;
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        double pred = 0.0;
        for (int r = 0; r < this.numRatingLevels; ++r) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            for (int k = 0; k < this.numTopics; ++k) {
                prob += this.userTopicProbs.get(userIdx, k) * this.topicItemRatingProbs[k][itemIdx][r];
            }
            pred += prob * rate;
        }
        return pred;
    }
}

