/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.common.LibrecException;
import net.librec.math.structure.MatrixEntry;
import net.librec.recommender.MatrixFactorizationRecommender;

public class PMFRecommender
extends MatrixFactorizationRecommender {
    @Override
    protected void setup() throws LibrecException {
        super.setup();
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int userId = me.row();
                int itemId = me.column();
                double realRating = me.get();
                double predictRating = this.predict(userId, itemId);
                double error = realRating - predictRating;
                this.loss += error * error;
                for (int factorId = 0; factorId < this.numFactors; ++factorId) {
                    double userFactor = this.userFactors.get(userId, factorId);
                    double itemFactor = this.itemFactors.get(itemId, factorId);
                    this.userFactors.add(userId, factorId, (double)this.learnRate * (error * itemFactor - (double)this.regUser * userFactor));
                    this.itemFactors.add(itemId, factorId, (double)this.learnRate * (error * userFactor - (double)this.regItem * itemFactor));
                    this.loss += (double)this.regUser * userFactor * userFactor + (double)this.regItem * itemFactor * itemFactor;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }
}

