/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseVector;
import net.librec.recommender.AbstractRecommender;

@ModelData(value={"isRating", "nmf", "transUserFactors", "transItemFactors"})
public class NMFRecommender
extends AbstractRecommender {
    DenseMatrix transUserFactors;
    DenseMatrix transItemFactors;
    protected int numFactors;
    protected int numIterations;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.numFactors = this.conf.getInt("rec.factor.number", 10);
        this.numIterations = this.conf.getInt("rec.iterator.maximum", 100);
        this.transUserFactors = new DenseMatrix(this.numFactors, this.numUsers);
        this.transItemFactors = new DenseMatrix(this.numFactors, this.numItems);
        this.transUserFactors.init(0.01);
        this.transItemFactors.init(0.01);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 0; iter <= this.numIterations; ++iter) {
            double estmValue;
            int factorIdx;
            for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                SparseVector itemRatingsVector = this.trainMatrix.row(userIdx);
                if (itemRatingsVector.getCount() <= 0) continue;
                SparseVector itemPredictsVector = new SparseVector(this.numItems, itemRatingsVector.size());
                for (int itemIdx : itemRatingsVector.getIndex()) {
                    itemPredictsVector.append(itemIdx, this.predict(userIdx, itemIdx));
                }
                for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    DenseVector factorItemsVector = this.transItemFactors.row(factorIdx, false);
                    double realValue = factorItemsVector.inner(itemRatingsVector);
                    estmValue = factorItemsVector.inner(itemPredictsVector) + 1.0E-9;
                    this.transUserFactors.set(factorIdx, userIdx, this.transUserFactors.get(factorIdx, userIdx) * (realValue / estmValue));
                }
            }
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                SparseVector userRatingsVector = this.trainMatrix.column(itemIdx);
                if (userRatingsVector.getCount() <= 0) continue;
                SparseVector userPredictsVector = new SparseVector(this.numUsers, userRatingsVector.size());
                for (int userIdx : userRatingsVector.getIndex()) {
                    userPredictsVector.append(userIdx, this.predict(userIdx, itemIdx));
                }
                for (factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    DenseVector factorUsersVector = this.transUserFactors.row(factorIdx, false);
                    double realValue = factorUsersVector.inner(userRatingsVector);
                    estmValue = factorUsersVector.inner(userPredictsVector) + 1.0E-9;
                    this.transItemFactors.set(factorIdx, itemIdx, this.transItemFactors.get(factorIdx, itemIdx) * (realValue / estmValue));
                }
            }
            this.loss = 0.0;
            for (MatrixEntry matrixEntry : this.trainMatrix) {
                int userIdx = matrixEntry.row();
                int itemIdx = matrixEntry.column();
                double rating = matrixEntry.get();
                if (!(rating > 0.0)) continue;
                double ratingError = this.predict(userIdx, itemIdx) - rating;
                this.loss += ratingError * ratingError;
            }
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return DenseMatrix.colMult(this.transUserFactors, userIdx, this.transItemFactors, itemIdx);
    }
}

