/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.DiagMatrix;
import net.librec.recommender.MatrixFactorizationRecommender;

@ModelData(value={"isRating", "biasedMF", "userFactors", "itemFactors"})
public class MFALSRecommender
extends MatrixFactorizationRecommender {
    @Override
    protected void trainModel() throws LibrecException {
        DiagMatrix identify = DiagMatrix.eye(this.numFactors);
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            Double realRating;
            int index1;
            int index;
            for (int userIdx = 0; userIdx < this.userFactors.numRows(); ++userIdx) {
                int numitems = this.trainMatrix.rowSize(userIdx);
                DenseMatrix M = new DenseMatrix(numitems, this.numFactors);
                index = 0;
                for (int itemIdx = 0; itemIdx < this.itemFactors.numRows(); ++itemIdx) {
                    if (!(this.trainMatrix.get(userIdx, itemIdx) > 0.0)) continue;
                    M.setRow(index++, this.itemFactors.row(itemIdx));
                }
                DenseMatrix A = M.transpose().mult(M).add(identify.scale(this.regUser).scale(numitems));
                DenseVector uservector = new DenseVector(numitems);
                index1 = 0;
                for (int itemIdx = 0; itemIdx < this.trainMatrix.numColumns(); ++itemIdx) {
                    realRating = this.trainMatrix.get(userIdx, itemIdx);
                    if (!(realRating > 0.0)) continue;
                    uservector.set(index1++, realRating);
                }
                this.userFactors.setRow(userIdx, A.inv().mult(M.transpose().mult(uservector)));
            }
            for (int itemIdx = 0; itemIdx < this.itemFactors.numRows(); ++itemIdx) {
                int numusers = this.trainMatrix.columnSize(itemIdx);
                DenseMatrix U = new DenseMatrix(numusers, this.numFactors);
                index = 0;
                for (int userIdx = 0; userIdx < this.userFactors.numRows(); ++userIdx) {
                    if (!(this.trainMatrix.get(userIdx, itemIdx) > 0.0)) continue;
                    U.setRow(index++, this.userFactors.row(userIdx));
                }
                if (U.numRows() == 0) continue;
                DenseMatrix A = U.transpose().mult(U).add(identify.scale(this.regItem).scale(numusers));
                DenseVector itemvector = new DenseVector(numusers);
                index1 = 0;
                for (int userIdx = 0; userIdx < this.trainMatrix.numRows(); ++userIdx) {
                    realRating = this.trainMatrix.get(userIdx, itemIdx);
                    if (!(realRating > 0.0)) continue;
                    itemvector.set(index1++, realRating);
                }
                this.itemFactors.setRow(itemIdx, A.inv().mult(U.transpose().mult(itemvector)));
            }
        }
    }
}

