/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.rating;

import com.google.common.collect.Table;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Gamma;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.recommender.MatrixFactorizationRecommender;

public class BPoissMFRecommender
extends MatrixFactorizationRecommender {
    private GammaDenseMatrix userTheta;
    private GammaDenseVector userThetaRate;
    private GammaDenseMatrix itemBeta;
    private GammaDenseVector itemBetaRate;
    private Table<Integer, Integer, Map<Integer, Double>> zTopic;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.userThetaRate = new GammaDenseVector(this.numFactors);
        this.itemBetaRate = new GammaDenseVector(this.numFactors);
        this.userTheta = new GammaDenseMatrix(this.numUsers, this.numFactors);
        this.itemBeta = new GammaDenseMatrix(this.numItems, this.numFactors);
        this.userThetaRate.shapePrior = this.conf.getDouble("rec.recommender.user.rateShapePrior", 0.1);
        this.userThetaRate.ratePrior = this.conf.getDouble("rec.recommender.user.rateRatePrior", 0.1);
        this.userThetaRate.init2(this.numFactors);
        this.userThetaRate.computeExpectations();
        this.itemBetaRate.shapePrior = this.conf.getDouble("rec.recommender.item.rateShapePrior", 0.1);
        this.itemBetaRate.ratePrior = this.conf.getDouble("rec.recommender.item.rateRatePrior", 0.1);
        this.itemBetaRate.init2(this.numFactors);
        this.itemBetaRate.computeExpectations();
        this.userTheta.shapePrior = this.conf.getDouble("rec.recommender.user.shapePrior", 0.1);
        this.userTheta.ratePrior = this.conf.getDouble("rec.recommender.user.ratePrior", 0.1);
        this.userTheta.init();
        this.itemBeta.shapePrior = this.conf.getDouble("rec.recommender.item.shapePrior", 0.1);
        this.itemBeta.ratePrior = this.conf.getDouble("rec.recommender.item.ratePrior", 0.1);
        this.itemBeta.init();
    }

    protected DenseVector getPhi(DenseMatrix Theta, int indexTheta, DenseMatrix Beta2, int indexBeta, int number) throws LibrecException {
        int i;
        DenseVector phi = new DenseVector(number);
        phi.setAll(0.0);
        assert (Theta.numColumns == Beta2.numColumns);
        for (i = 0; i < Theta.numColumns; ++i) {
            phi.add(Math.log(Beta2.get(indexBeta, i)) + Theta.get(indexTheta, i));
        }
        phi = phi.scale(1.0 / phi.sum());
        for (i = 0; i < Theta.numColumns; ++i) {
            phi.set(i, Math.log(phi.get(i)));
        }
        return phi;
    }

    @Override
    protected void trainModel() throws LibrecException {
        double[] loglikelihood = new double[this.numIterations];
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            for (MatrixEntry matrixEntry : this.trainMatrix) {
                int user_id = matrixEntry.row();
                int item_id = matrixEntry.column();
                double rating = matrixEntry.get();
                DenseVector phi = this.getPhi(this.userTheta.logValue, user_id, this.itemBeta.value, item_id, this.numFactors);
                if (!(rating > 1.0)) continue;
                phi.scale(rating);
            }
        }
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        return DenseMatrix.rowMult(this.userTheta.value, userIdx, this.itemBeta.value, itemIdx);
    }

    public class GammaDenseMatrixGR {
        protected int numRows;
        protected int numColumns;
        protected double shapePrior;
        protected double ratePrior;
        protected DenseMatrix shape;
        protected DenseVector rate;
        protected DenseMatrix value;
        protected DenseMatrix logValue;

        public GammaDenseMatrixGR(int _numRows, int _numColumns) {
            this.numRows = _numRows;
            this.numColumns = _numColumns;
            this.shape = new DenseMatrix(this.numRows, this.numColumns);
            this.rate = new DenseVector(this.numColumns);
            this.value = new DenseMatrix(this.numRows, this.numColumns);
            this.logValue = new DenseMatrix(this.numRows, this.numColumns);
        }

        public void init() {
            int j;
            int i;
            for (i = 0; i < this.numRows; ++i) {
                for (j = 0; j < this.numColumns; ++j) {
                    this.shape.set(i, j, this.shapePrior + 0.01 * Randoms.uniform(0.0, 1.0));
                }
            }
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                this.rate.set(j2, this.ratePrior + 0.1 * Randoms.uniform(0.0, 1.0));
            }
            for (i = 0; i < this.numRows; ++i) {
                for (j = 0; j < this.numColumns; ++j) {
                    this.value.set(i, j, this.shape.get(i, j) / this.rate.get(j));
                    this.logValue.set(i, j, Gamma.digamma(this.shape.get(i, j)) - Math.log(this.rate.get(j)));
                }
            }
        }

        public void computeExpectations() {
            double a = 0.0;
            double b = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numColumns; ++j) {
                    if (this.shape.get(i, j) <= 0.0) {
                        a = 1.0E-30;
                    }
                    if (this.rate.get(j) <= 0.0) {
                        b = 1.0E-30;
                    }
                    this.value.set(i, j, a / b);
                    this.logValue.set(i, j, Gamma.digamma(a) - Math.log(b));
                }
            }
        }
    }

    public class GammaDenseMatrix {
        protected int numRows;
        protected int numColumns;
        protected double shapePrior;
        protected double ratePrior;
        protected DenseMatrix shape;
        protected DenseMatrix rate;
        protected DenseMatrix value;
        protected DenseMatrix logValue;

        public GammaDenseMatrix(int _numRows, int _numColumns) {
            this.numRows = _numRows;
            this.numColumns = _numColumns;
            this.shape = new DenseMatrix(this.numRows, this.numColumns);
            this.rate = new DenseMatrix(this.numRows, this.numColumns);
            this.value = new DenseMatrix(this.numRows, this.numColumns);
            this.logValue = new DenseMatrix(this.numRows, this.numColumns);
        }

        public void init() {
            int j;
            int i;
            for (i = 0; i < this.numRows; ++i) {
                for (j = 0; j < this.numColumns; ++j) {
                    this.shape.set(i, j, this.shapePrior + 0.01 * Randoms.uniform(0.0, 1.0));
                    if (i == 0) {
                        this.rate.set(0, j, this.ratePrior + 0.1 * Randoms.uniform(0.0, 1.0));
                        continue;
                    }
                    this.rate.set(i, j, this.rate.get(0, j));
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                for (j = 0; j < this.numColumns; ++j) {
                    this.value.set(i, j, this.shape.get(i, j) / this.rate.get(i, j));
                    this.logValue.set(i, j, Gamma.digamma(this.shape.get(i, j)) - Math.log(this.rate.get(i, j)));
                }
            }
        }

        public void computeExpectations() {
            double a = 0.0;
            double b = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numColumns; ++j) {
                    if (this.shape.get(i, j) <= 0.0) {
                        a = 1.0E-30;
                    }
                    if (this.rate.get(i, j) <= 0.0) {
                        b = 1.0E-30;
                    }
                    this.value.set(i, j, a / b);
                    this.logValue.set(i, j, Gamma.digamma(a) - Math.log(b));
                }
            }
        }
    }

    public class GammaDenseVector {
        protected int size;
        protected double shapePrior;
        protected double ratePrior;
        protected DenseVector shape;
        protected DenseVector rate;
        protected DenseVector value;
        protected DenseVector logValue;

        public GammaDenseVector(int _size) {
            this.size = _size;
            this.shape = new DenseVector(this.size);
            this.rate = new DenseVector(this.size);
            this.value = new DenseVector(this.size);
            this.logValue = new DenseVector(this.size);
        }

        public void init() {
            for (int i = 0; i < this.size; ++i) {
                this.shape.set(i, this.shapePrior + 0.01 * Randoms.uniform(0.0, 1.0));
                this.rate.set(i, this.ratePrior + 0.1 * Randoms.uniform(0.0, 1.0));
            }
        }

        public void init2(double v) {
            for (int i = 0; i < this.size; ++i) {
                this.shape.set(i, this.shapePrior + 0.01 * Randoms.uniform(0.0, 1.0));
                this.rate.set(i, this.ratePrior + v);
            }
        }

        public void computeExpectations() {
            double a = 0.0;
            double b = 0.0;
            for (int i = 0; i < this.size; ++i) {
                if (this.shape.get(i) <= 0.0) {
                    a = 1.0E-30;
                }
                if (this.rate.get(i) <= 0.0) {
                    b = 1.0E-30;
                }
                this.value.set(i, a / b);
                this.logValue.set(i, Gamma.digamma(a) - Math.log(b));
            }
        }
    }
}

