/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.Date;
import java.util.List;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.DiagMatrix;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.MatrixFactorizationRecommender;

@ModelData(value={"isRanking", "wrmf", "userFactors", "itemFactors", "trainMatrix"})
public class WRMFRecommender
extends MatrixFactorizationRecommender {
    protected float weightCoefficient;
    protected SparseMatrix confindenceMinusIdentityMatrix;
    protected SparseMatrix preferenceMatrix;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.weightCoefficient = this.conf.getFloat("rec.wrmf.weight.coefficient", Float.valueOf(4.0f)).floatValue();
        this.confindenceMinusIdentityMatrix = new SparseMatrix(this.trainMatrix);
        this.preferenceMatrix = new SparseMatrix(this.trainMatrix);
        for (MatrixEntry matrixEntry : this.trainMatrix) {
            int userIdx = matrixEntry.row();
            int itemIdx = matrixEntry.column();
            this.confindenceMinusIdentityMatrix.set(userIdx, itemIdx, Math.log(1.0 + Math.pow(10.0, this.weightCoefficient) * matrixEntry.get()));
            this.preferenceMatrix.set(userIdx, itemIdx, 1.0);
        }
    }

    @Override
    protected void trainModel() throws LibrecException {
        DiagMatrix userIdentityMatrix = DiagMatrix.eye(this.numFactors).scale(this.regUser);
        DiagMatrix itemIdentityMatrix = DiagMatrix.eye(this.numFactors).scale(this.regItem);
        DenseMatrix X = this.userFactors;
        DenseMatrix Y = this.itemFactors;
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            Object YtCuPu;
            DenseMatrix Yt = Y.transpose();
            DenseMatrix YtY = Yt.mult(Y);
            for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
                DenseMatrix YtCuI = new DenseMatrix(this.numFactors, this.numItems);
                List<Integer> itemList = this.trainMatrix.getColumns(userIdx);
                for (int itemIdx : itemList) {
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        YtCuI.set(factorIdx, itemIdx, Y.get(itemIdx, factorIdx) * this.confindenceMinusIdentityMatrix.get(userIdx, itemIdx));
                    }
                }
                DenseMatrix YtCuY = new DenseMatrix(this.numFactors, this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int factorIdxIn = 0; factorIdxIn < this.numFactors; ++factorIdxIn) {
                        double value = 0.0;
                        for (int itemIdx : itemList) {
                            value += YtCuI.get(factorIdx, itemIdx) * Y.get(itemIdx, factorIdxIn);
                        }
                        YtCuY.set(factorIdx, factorIdxIn, value);
                    }
                }
                YtCuY.addEqual(YtY);
                DenseMatrix Wu = YtCuY.add(userIdentityMatrix).inv();
                YtCuPu = new DenseVector(this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int itemIdx : itemList) {
                        ((DenseVector)YtCuPu).add(factorIdx, this.preferenceMatrix.get(userIdx, itemIdx) * (YtCuI.get(factorIdx, itemIdx) + Yt.get(factorIdx, itemIdx)));
                    }
                }
                DenseVector xu = Wu.mult((DenseVector)YtCuPu);
                X.setRow(userIdx, xu);
            }
            DenseMatrix Xt = X.transpose();
            DenseMatrix XtX = Xt.mult(X);
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                DenseMatrix XtCiI = new DenseMatrix(this.numFactors, this.numUsers);
                List<Integer> userList = this.trainMatrix.getRows(itemIdx);
                YtCuPu = userList.iterator();
                while (YtCuPu.hasNext()) {
                    int userIdx = YtCuPu.next();
                    for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                        XtCiI.set(factorIdx, userIdx, X.get(userIdx, factorIdx) * this.confindenceMinusIdentityMatrix.get(userIdx, itemIdx));
                    }
                }
                DenseMatrix XtCiX = new DenseMatrix(this.numFactors, this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int factorIdxIn = 0; factorIdxIn < this.numFactors; ++factorIdxIn) {
                        double value = 0.0;
                        for (int userIdx : userList) {
                            value += XtCiI.get(factorIdx, userIdx) * X.get(userIdx, factorIdxIn);
                        }
                        XtCiX.set(factorIdx, factorIdxIn, value);
                    }
                }
                XtCiX.addEqual(XtX);
                DenseMatrix Wi = XtCiX.add(itemIdentityMatrix).inv();
                DenseVector XtCiPu = new DenseVector(this.numFactors);
                for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
                    for (int userIdx : userList) {
                        XtCiPu.add(factorIdx, this.preferenceMatrix.get(userIdx, itemIdx) * (XtCiI.get(factorIdx, userIdx) + Xt.get(factorIdx, userIdx)));
                    }
                }
                DenseVector yi = Wi.mult(XtCiPu);
                Y.setRow(itemIdx, yi);
            }
            if (!verbose) continue;
            this.LOG.info(this.getClass() + " runs at iteration = " + iter + " " + new Date());
        }
    }
}

