/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "slim", "coefficientMatrix", "trainMatrix", "similarityMatrix", "knn"})
public class SLIMRecommender
extends AbstractRecommender {
    protected int numIterations;
    private DenseMatrix coefficientMatrix;
    private Set<Integer>[] itemNNs;
    private float regL1Norm;
    private float regL2Norm;
    protected static int knn;
    private SymmMatrix similarityMatrix;
    private Set<Integer> allItems;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        knn = this.conf.getInt("rec.neighbors.knn.number", 50);
        this.numIterations = this.conf.getInt("rec.iterator.maximum");
        this.regL1Norm = this.conf.getFloat("rec.slim.regularization.l1", Float.valueOf(1.0f)).floatValue();
        this.regL2Norm = this.conf.getFloat("rec.slim.regularization.l2", Float.valueOf(1.0f)).floatValue();
        this.coefficientMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.coefficientMatrix.init();
        this.similarityMatrix = this.context.getSimilarity().getSimilarityMatrix();
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            this.coefficientMatrix.set(itemIdx, itemIdx, 0.0);
        }
        this.createItemNNs();
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                Set<Integer> nearestNeighborCollection = knn > 0 ? this.itemNNs[itemIdx] : this.allItems;
                double[] userRatingEntries = new double[this.numUsers];
                Iterator<VectorEntry> userItr = this.trainMatrix.rowIterator(itemIdx);
                while (userItr.hasNext()) {
                    VectorEntry userRatingEntry = userItr.next();
                    userRatingEntries[userRatingEntry.index()] = userRatingEntry.get();
                }
                for (Integer nearestNeighborItemIdx : nearestNeighborCollection) {
                    if (nearestNeighborItemIdx == itemIdx) continue;
                    double gradSum = 0.0;
                    double rateSum = 0.0;
                    double errors = 0.0;
                    Iterator<VectorEntry> nnUserRatingItr = this.trainMatrix.rowIterator(nearestNeighborItemIdx);
                    if (!nnUserRatingItr.hasNext()) continue;
                    int nnCount = 0;
                    while (nnUserRatingItr.hasNext()) {
                        VectorEntry nnUserVectorEntry = nnUserRatingItr.next();
                        int nnUserIdx = nnUserVectorEntry.index();
                        double nnRating = nnUserVectorEntry.get();
                        double rating = userRatingEntries[nnUserIdx];
                        double error = rating - this.predict(nnUserIdx, itemIdx, nearestNeighborItemIdx);
                        gradSum += nnRating * error;
                        rateSum += nnRating * nnRating;
                        errors += error * error;
                        ++nnCount;
                    }
                    gradSum /= (double)nnCount;
                    rateSum /= (double)nnCount;
                    double coefficient = this.coefficientMatrix.get(nearestNeighborItemIdx, itemIdx);
                    this.loss += (errors /= (double)nnCount) + 0.5 * (double)this.regL2Norm * coefficient * coefficient + (double)this.regL1Norm * coefficient;
                    double update = 0.0;
                    if ((double)this.regL1Norm < Math.abs(gradSum)) {
                        update = gradSum > 0.0 ? (gradSum - (double)this.regL1Norm) / ((double)this.regL2Norm + rateSum) : (gradSum + (double)this.regL1Norm) / ((double)this.regL2Norm + rateSum);
                    }
                    this.coefficientMatrix.set(nearestNeighborItemIdx, itemIdx, update);
                }
            }
            if (this.isConverged(iter) && this.earlyStop) break;
        }
    }

    protected double predict(int userIdx, int itemIdx, int excludedItemIdx) {
        double predictRating = 0.0;
        Iterator<VectorEntry> itemEntryIterator = this.trainMatrix.colIterator(userIdx);
        while (itemEntryIterator.hasNext()) {
            VectorEntry itemEntry = itemEntryIterator.next();
            int nearestNeighborItemIdx = itemEntry.index();
            double nearestNeighborPredictRating = itemEntry.get();
            if (!this.itemNNs[itemIdx].contains(nearestNeighborItemIdx) || nearestNeighborItemIdx == excludedItemIdx) continue;
            predictRating += nearestNeighborPredictRating * this.coefficientMatrix.get(nearestNeighborItemIdx, itemIdx);
        }
        return predictRating;
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.lastLoss - this.loss;
        this.lastLoss = this.loss;
        if (verbose) {
            String recName = this.getClass().getSimpleName().toString();
            String info = recName + " iter " + iter + ": loss = " + this.loss + ", delta_loss = " + delta_loss;
            this.LOG.info(info);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }

    @Override
    protected double predict(int userIdx, int itemIdx) throws LibrecException {
        if (null == this.itemNNs || this.itemNNs.length <= 0) {
            this.createItemNNs();
        }
        return this.predict(userIdx, itemIdx, -1);
    }

    public void createItemNNs() {
        this.itemNNs = new HashSet[this.numItems];
        if (knn > 0) {
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                SparseVector similarityVector = this.similarityMatrix.row(itemIdx);
                if (knn < similarityVector.size()) {
                    List tempItemSimList = new ArrayList(similarityVector.size() + 1);
                    for (VectorEntry simVectorEntry : similarityVector) {
                        tempItemSimList.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(simVectorEntry.index(), simVectorEntry.get()));
                    }
                    tempItemSimList = Lists.sortListTopK(tempItemSimList, true, knn);
                    this.itemNNs[itemIdx] = new HashSet<Integer>((int)((double)tempItemSimList.size() / 0.5));
                    for (Map.Entry tempItemSimEntry : tempItemSimList) {
                        this.itemNNs[itemIdx].add((Integer)tempItemSimEntry.getKey());
                    }
                    continue;
                }
                this.itemNNs[itemIdx] = similarityVector.getIndexSet();
            }
        } else {
            this.allItems = new HashSet<Integer>(this.trainMatrix.columns());
        }
    }
}

