/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SparseVector;
import net.librec.recommender.MatrixFactorizationRecommender;

@ModelData(value={"isRanking", "fismauc", "P", "Q", "itemBiases", "userBiases"})
public class FISMaucRecommender
extends MatrixFactorizationRecommender {
    protected static String cacheSpec;
    protected LoadingCache<Integer, List<Integer>> userItemsCache;
    private float rho;
    private float alpha;
    private float beta;
    private float gamma;
    private double lRate;
    private DenseVector itemBiases;
    private DenseMatrix P;
    private DenseMatrix Q;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.P = new DenseMatrix(this.numItems, this.numFactors);
        this.Q = new DenseMatrix(this.numItems, this.numFactors);
        this.P.init(0.0, 0.01);
        this.Q.init(0.0, 0.01);
        this.itemBiases = new DenseVector(this.numItems);
        this.itemBiases.init(0.0, 0.01);
        this.rho = this.conf.getFloat("rec.recommender.rho").floatValue();
        this.alpha = this.conf.getFloat("rec.recommender.alpha", Float.valueOf(0.5f)).floatValue();
        this.beta = this.conf.getFloat("rec.recommender.beta", Float.valueOf(0.6f)).floatValue();
        this.gamma = this.conf.getFloat("rec.recommender.gamma", Float.valueOf(0.1f)).floatValue();
        this.lRate = this.conf.getDouble("rec.iteration.learnrate", 1.0E-4);
        cacheSpec = this.conf.get("guava.cache.spec", "maximumSize=200,expireAfterAccess=2m");
        this.userItemsCache = this.trainMatrix.rowColumnsCache(cacheSpec);
    }

    @Override
    protected void trainModel() throws LibrecException {
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                SparseVector Ru = this.trainMatrix.row(u);
                int Ru_p_size = Ru.size();
                if (Ru_p_size == 0 || Ru_p_size == 1) {
                    Ru_p_size = 2;
                }
                for (int i : Ru.getIndex()) {
                    DenseVector x = new DenseVector(this.numFactors);
                    x.init(0.0);
                    DenseVector t = new DenseVector(this.numFactors);
                    t.init(0.0);
                    for (int j : Ru.getIndex()) {
                        if (i == j) continue;
                        t = t.add(this.P.row(j));
                    }
                    t = t.scale(Math.pow(Ru_p_size - 1, -this.alpha));
                    for (int tindex = 0; tindex < this.numFactors; ++tindex) {
                        if (!Double.isNaN(t.get(tindex))) continue;
                        System.out.println("user:" + u + ", item:" + i + ", Ru_p_size:" + Ru_p_size);
                    }
                    int sampleSize = (int)(this.rho * (float)Ru_p_size);
                    List<Integer> negative_indices = null;
                    try {
                        negative_indices = Randoms.randInts(sampleSize, 0, this.numItems);
                        Iterator<Integer> iterator = negative_indices.iterator();
                        while (iterator.hasNext()) {
                            int index = iterator.next();
                            if (!(Ru.get(index) > 0.1)) continue;
                            iterator.remove();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Iterator<Integer> iterator = negative_indices.iterator();
                    while (iterator.hasNext()) {
                        int j;
                        j = iterator.next();
                        double bi = this.itemBiases.get(i);
                        double bj = this.itemBiases.get(j);
                        double rui = Ru.get(i);
                        double pui = bi + this.Q.row(i).inner(t);
                        double puj = bj + this.Q.row(j).inner(t);
                        double ruj = 0.0;
                        double e = rui - ruj - (pui - puj);
                        this.loss += e * e;
                        this.itemBiases.add(i, this.lRate * (e - (double)this.gamma * bi));
                        this.itemBiases.add(j, this.lRate * (e - (double)this.gamma * bj));
                        DenseVector delta_qi = t.scale(e).minus(this.Q.row(i).scale(this.beta));
                        DenseVector qi = this.Q.row(i).add(delta_qi.scale(this.lRate));
                        this.Q.setRow(i, qi);
                        DenseVector delta_qj = t.scale(e).minus(this.Q.row(j).scale(this.beta));
                        DenseVector qj = this.Q.row(j).minus(delta_qj.scale(this.lRate));
                        this.Q.setRow(j, qj);
                        x = x.add(qi.minus(qj).scale(e));
                    }
                    for (Object j : (Iterator<Integer>)Ru.getIndex()) {
                        if (j == i) continue;
                        DenseVector delta_pj = x.scale(Math.pow(this.rho, -1.0) * Math.pow(Ru_p_size - 1, -this.alpha)).minus(this.P.row((int)j).scale(this.beta));
                        this.P.setRow((int)j, this.P.row((int)j).add(delta_pj.scale(this.lRate)));
                    }
                }
            }
            for (int i = 0; i < this.numItems; ++i) {
                double bi = this.itemBiases.get(i);
                this.loss += (double)this.gamma * bi * bi;
                this.loss += (double)this.beta * this.Q.row(i).inner(this.Q.row(i));
                this.loss += (double)this.beta * this.P.row(i).inner(this.P.row(i));
            }
            this.loss *= 0.5;
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }

    @Override
    protected double predict(int u, int j) throws LibrecException {
        double pred = this.itemBiases.get(j);
        double sum = 0.0;
        int count = 0;
        List<Integer> ratedItems = null;
        try {
            ratedItems = this.userItemsCache.get(u);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Iterator e = ratedItems.iterator();
        while (e.hasNext()) {
            int i = (Integer)e.next();
            if (i == j) continue;
            sum += DenseMatrix.rowMult(this.P, i, this.Q, j);
            ++count;
        }
        double wu = count - 1 > 0 ? Math.pow(count - 1, -this.alpha) : 0.0;
        return pred + wu * sum;
    }
}

