/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf.ranking;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.algorithm.Maths;
import net.librec.math.algorithm.Randoms;
import net.librec.math.algorithm.Stats;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.MatrixFactorizationRecommender;
import net.librec.recommender.item.RecommendedItemList;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "aobpr", "userFactors", "itemFactors"})
public class AoBPRRecommender
extends MatrixFactorizationRecommender {
    private int loopNumber;
    private int lambdaItem;
    private double[] var;
    private int[][] factorRanking;
    private double[] RankingPro;
    private List<Set<Integer>> userItemsSet;

    @Override
    protected void setup() throws LibrecException {
        int i;
        super.setup();
        this.lambdaItem = (int)(this.conf.getFloat("rec.item.distribution.parameter").floatValue() * (float)this.numItems);
        this.loopNumber = (int)((double)this.numItems * Math.log(this.numItems));
        this.var = new double[this.numFactors];
        this.factorRanking = new int[this.numFactors][this.numItems];
        this.RankingPro = new double[this.numItems];
        double sum = 0.0;
        for (i = 0; i < this.numItems; ++i) {
            this.RankingPro[i] = Math.exp(-(i + 1) / this.lambdaItem);
            sum += this.RankingPro[i];
        }
        i = 0;
        while (i < this.numItems) {
            int n = i++;
            this.RankingPro[n] = this.RankingPro[n] / sum;
        }
        this.recommendedList = new RecommendedItemList(this.numUsers);
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.userItemsSet = this.getUserItemsSet(this.trainMatrix);
        List<Integer>[] dataLists = this.getTrainList(this.trainMatrix);
        List<Integer> userTrainList = dataLists[0];
        List<Integer> itemTrainList = dataLists[1];
        int countIter = 0;
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            this.loss = 0.0;
            int smax = this.numUsers * 100;
            for (int s = 0; s < smax; ++s) {
                int randomNegItemIndex;
                double[] pfc;
                int factorIdx;
                int negItemIdx;
                int dataIdx;
                int userIdx;
                Set<Integer> itemSet;
                if (countIter % this.loopNumber == 0) {
                    this.updateRankingInFactor();
                    countIter = 0;
                }
                ++countIter;
                while ((itemSet = this.userItemsSet.get(userIdx = userTrainList.get(dataIdx = Randoms.uniform(this.numRates)).intValue())).size() == 0 || itemSet.size() == this.numItems) {
                }
                int posItemIdx = itemTrainList.get(dataIdx);
                do {
                    int pfcFactprIdx;
                    randomNegItemIndex = 0;
                    while ((randomNegItemIndex = Randoms.discrete(this.RankingPro)) > this.numItems) {
                    }
                    pfc = new double[this.numFactors];
                    double sumfc = 0.0;
                    for (pfcFactprIdx = 0; pfcFactprIdx < this.numFactors; ++pfcFactprIdx) {
                        double tempAbsValue = Math.abs(this.userFactors.get(userIdx, pfcFactprIdx));
                        sumfc += tempAbsValue * this.var[pfcFactprIdx];
                        pfc[pfcFactprIdx] = tempAbsValue * this.var[pfcFactprIdx];
                    }
                    pfcFactprIdx = 0;
                    while (pfcFactprIdx < this.numFactors) {
                        int n = pfcFactprIdx++;
                        pfc[n] = pfc[n] / sumfc;
                    }
                } while (itemSet.contains(negItemIdx = this.userFactors.get(userIdx, factorIdx = Randoms.discrete(pfc)) > 0.0 ? this.factorRanking[factorIdx][randomNegItemIndex] : this.factorRanking[factorIdx][this.numItems - randomNegItemIndex - 1]));
                double posPredictRating = this.predict(userIdx, posItemIdx);
                double negPredictRating = this.predict(userIdx, negItemIdx);
                double diffValue = posPredictRating - negPredictRating;
                double lossValue = -Math.log(Maths.logistic(diffValue));
                this.loss += lossValue;
                double deriValue = Maths.logistic(-diffValue);
                for (int factorIdx2 = 0; factorIdx2 < this.numFactors; ++factorIdx2) {
                    double userFactorValue = this.userFactors.get(userIdx, factorIdx2);
                    double posItemFactorValue = this.itemFactors.get(posItemIdx, factorIdx2);
                    double negItemFactorValue = this.itemFactors.get(negItemIdx, factorIdx2);
                    this.userFactors.add(userIdx, factorIdx2, (double)this.learnRate * (deriValue * (posItemFactorValue - negItemFactorValue) - (double)this.regUser * userFactorValue));
                    this.itemFactors.add(posItemIdx, factorIdx2, (double)this.learnRate * (deriValue * userFactorValue - (double)this.regItem * posItemFactorValue));
                    this.itemFactors.add(negItemIdx, factorIdx2, (double)this.learnRate * (deriValue * -userFactorValue - (double)this.regItem * negItemFactorValue));
                    this.loss += (double)this.regUser * userFactorValue * userFactorValue + (double)this.regItem * posItemFactorValue * posItemFactorValue + (double)this.regItem * negItemFactorValue * negItemFactorValue;
                }
            }
            if (this.isConverged(iter) && this.earlyStop) break;
            this.updateLRate(iter);
        }
    }

    public List<Map.Entry<Integer, Double>> sortByDenseVectorValue(DenseVector vector) {
        ArrayList<Map.Entry<Integer, Double>> sortList = new ArrayList<Map.Entry<Integer, Double>>();
        int length = vector.getData().length;
        for (int itemIdx = 0; itemIdx < length; ++itemIdx) {
            sortList.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(itemIdx, vector.get(itemIdx)));
        }
        Lists.sortList(sortList, true);
        return sortList;
    }

    public void updateRankingInFactor() {
        for (int factorIdx = 0; factorIdx < this.numFactors; ++factorIdx) {
            DenseVector factorVector = this.itemFactors.column(factorIdx).clone();
            List<Map.Entry<Integer, Double>> sort = this.sortByDenseVectorValue(factorVector);
            double[] valueList = new double[this.numItems];
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                this.factorRanking[factorIdx][itemIdx] = sort.get(itemIdx).getKey();
                valueList[itemIdx] = sort.get(itemIdx).getValue();
            }
            this.var[factorIdx] = Stats.var(valueList);
        }
    }

    private List<Set<Integer>> getUserItemsSet(SparseMatrix sparseMatrix) {
        ArrayList<Set<Integer>> userItemsSet = new ArrayList<Set<Integer>>();
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            userItemsSet.add(new HashSet<Integer>(sparseMatrix.getColumns(userIdx)));
        }
        return userItemsSet;
    }

    private List<Integer>[] getTrainList(SparseMatrix sparseMatrix) {
        ArrayList<Integer> userTrainList = new ArrayList<Integer>();
        ArrayList<Integer> itemTrainList = new ArrayList<Integer>();
        for (MatrixEntry matrixEntry : sparseMatrix) {
            int userIdx = matrixEntry.row();
            int itemIdx = matrixEntry.column();
            userTrainList.add(userIdx);
            itemTrainList.add(itemIdx);
        }
        return new List[]{userTrainList, itemTrainList};
    }
}

