/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "knn", "userMeans", "trainMatrix", "similarityMatrix"})
public class UserKNNRecommender
extends AbstractRecommender {
    private int knn;
    private DenseVector userMeans;
    private SymmMatrix similarityMatrix;
    private List<Map.Entry<Integer, Double>>[] userSimilarityList;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.knn = this.conf.getInt("rec.neighbors.knn.number");
        this.similarityMatrix = this.context.getSimilarity().getSimilarityMatrix();
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.userMeans = new DenseVector(this.numUsers);
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            SparseVector userRatingVector = this.trainMatrix.row(userIdx);
            this.userMeans.set(userIdx, userRatingVector.getCount() > 0 ? userRatingVector.mean() : this.globalMean);
        }
    }

    @Override
    public double predict(int userIdx, int itemIdx) throws LibrecException {
        if (null == this.userSimilarityList || this.userSimilarityList.length <= 0) {
            this.createUserSimilarityList();
        }
        ArrayList<Map.Entry<Integer, Double>> nns = new ArrayList<Map.Entry<Integer, Double>>();
        List<Map.Entry<Integer, Double>> simList = this.userSimilarityList[userIdx];
        int count = 0;
        Set<Integer> userSet = this.trainMatrix.getRowsSet(itemIdx);
        for (Map.Entry<Integer, Double> userRatingEntry : simList) {
            int similarUserIdx = userRatingEntry.getKey();
            if (!userSet.contains(similarUserIdx)) continue;
            double d = userRatingEntry.getValue();
            if (this.isRanking) {
                nns.add(userRatingEntry);
                ++count;
            } else if (d > 0.0) {
                nns.add(userRatingEntry);
                ++count;
            }
            if (count != this.knn) continue;
            break;
        }
        if (nns.size() == 0) {
            return this.isRanking ? 0.0 : this.globalMean;
        }
        if (this.isRanking) {
            double sum = 0.0;
            for (Map.Entry entry : nns) {
                sum += ((Double)entry.getValue()).doubleValue();
            }
            return sum;
        }
        double sum = 0.0;
        double ws = 0.0;
        for (Map.Entry entry : nns) {
            int similarUserIdx = (Integer)entry.getKey();
            double sim = (Double)entry.getValue();
            double rate = this.trainMatrix.get(similarUserIdx, itemIdx);
            sum += sim * (rate - this.userMeans.get(similarUserIdx));
            ws += Math.abs(sim);
        }
        return ws > 0.0 ? this.userMeans.get(userIdx) + sum / ws : this.globalMean;
    }

    public void createUserSimilarityList() {
        this.userSimilarityList = new ArrayList[this.numUsers];
        for (int userIndex = 0; userIndex < this.numUsers; ++userIndex) {
            SparseVector similarityVector = this.similarityMatrix.row(userIndex);
            this.userSimilarityList[userIndex] = new ArrayList<Map.Entry<Integer, Double>>(similarityVector.size());
            for (VectorEntry simVectorEntry : similarityVector) {
                this.userSimilarityList[userIndex].add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(simVectorEntry.index(), simVectorEntry.get()));
            }
            Lists.sortList(this.userSimilarityList[userIndex], true);
        }
    }
}

