/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender.cf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.annotation.ModelData;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.SymmMatrix;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;
import net.librec.util.Lists;

@ModelData(value={"isRanking", "knn", "itemMeans", "trainMatrix", "similarityMatrix"})
public class ItemKNNRecommender
extends AbstractRecommender {
    private int knn;
    private DenseVector itemMeans;
    private SymmMatrix similarityMatrix;
    private List<Map.Entry<Integer, Double>>[] itemSimilarityList;
    private int currentUserIdx = -1;
    private Set<Integer> currentItemIdxSet;

    @Override
    protected void setup() throws LibrecException {
        super.setup();
        this.knn = this.conf.getInt("rec.neighbors.knn.number", 50);
        this.similarityMatrix = this.context.getSimilarity().getSimilarityMatrix();
    }

    @Override
    protected void trainModel() throws LibrecException {
        this.itemMeans = new DenseVector(this.numItems);
        int numRates = this.trainMatrix.size();
        double globalMean = this.trainMatrix.sum() / (double)numRates;
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            SparseVector userRatingVector = this.trainMatrix.column(itemIdx);
            this.itemMeans.set(itemIdx, userRatingVector.getCount() > 0 ? userRatingVector.mean() : globalMean);
        }
    }

    @Override
    public double predict(int userIdx, int itemIdx) throws LibrecException {
        if (null == this.itemSimilarityList || this.itemSimilarityList.length <= 0) {
            this.createItemSimilarityList();
        }
        if (this.currentUserIdx != userIdx) {
            this.currentItemIdxSet = this.trainMatrix.getColumnsSet(userIdx);
            this.currentUserIdx = userIdx;
        }
        ArrayList<Map.Entry<Integer, Double>> nns = new ArrayList<Map.Entry<Integer, Double>>();
        List<Map.Entry<Integer, Double>> simList = this.itemSimilarityList[itemIdx];
        int count = 0;
        for (Map.Entry<Integer, Double> itemRatingEntry : simList) {
            int similarItemIdx = itemRatingEntry.getKey();
            if (!this.currentItemIdxSet.contains(similarItemIdx)) continue;
            double d = itemRatingEntry.getValue();
            if (this.isRanking) {
                nns.add(itemRatingEntry);
                ++count;
            } else if (d > 0.0) {
                nns.add(itemRatingEntry);
                ++count;
            }
            if (count != this.knn) continue;
            break;
        }
        if (nns.size() == 0) {
            return this.isRanking ? 0.0 : this.globalMean;
        }
        if (this.isRanking) {
            double sum = 0.0;
            for (Map.Entry entry : nns) {
                sum += ((Double)entry.getValue()).doubleValue();
            }
            return sum;
        }
        double sum = 0.0;
        double ws = 0.0;
        for (Map.Entry entry : nns) {
            int similarItemIdx = (Integer)entry.getKey();
            double sim = (Double)entry.getValue();
            double rate = this.trainMatrix.get(userIdx, similarItemIdx);
            sum += sim * (rate - this.itemMeans.get(similarItemIdx));
            ws += Math.abs(sim);
        }
        return ws > 0.0 ? this.itemMeans.get(itemIdx) + sum / ws : this.globalMean;
    }

    public void createItemSimilarityList() {
        this.itemSimilarityList = new ArrayList[this.numItems];
        for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
            SparseVector similarityVector = this.similarityMatrix.row(itemIdx);
            this.itemSimilarityList[itemIdx] = new ArrayList<Map.Entry<Integer, Double>>(similarityVector.size());
            for (VectorEntry simVectorEntry : similarityVector) {
                this.itemSimilarityList[itemIdx].add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(simVectorEntry.index(), simVectorEntry.get()));
            }
            Lists.sortList(this.itemSimilarityList[itemIdx], true);
        }
    }
}

