/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.model.ArffDataModel;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.math.structure.SparseTensor;
import net.librec.math.structure.TensorEntry;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.recommender.item.RecommendedItemList;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TensorRecommender
implements Recommender {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected boolean isRanking;
    protected int topN;
    protected Configuration conf;
    protected RecommenderContext context;
    protected SparseTensor trainTensor;
    protected SparseTensor testTensor;
    protected SparseTensor validTensor;
    protected RecommendedList recommendedList;
    public BiMap<String, Integer> userMappingData;
    public BiMap<String, Integer> itemMappingData;
    public ArrayList<BiMap<String, Integer>> allFeaturesMappingData;
    protected boolean earlyStop;
    protected int numDimensions;
    protected int[] dimensions;
    protected int numFactors;
    protected double loss;
    protected double lastLoss = 0.0;
    protected boolean isBoldDriver;
    protected float decay;
    protected boolean verbose = true;
    protected float learnRate;
    protected float maxLearnRate;
    protected int numIterations;
    protected int userDimension;
    protected int itemDimension;
    protected float reg;
    protected int numUsers;
    protected int numItems;
    protected double maxRate = Double.MIN_NORMAL;
    protected double minRate = Double.MAX_VALUE;
    protected double globalMean;

    protected void setup() throws LibrecException {
        this.conf = this.context.getConf();
        this.isRanking = this.conf.getBoolean("rec.recommender.isranking");
        if (this.isRanking) {
            this.topN = this.conf.getInt("rec.recommender.ranking.topn", 5);
        }
        this.earlyStop = this.conf.getBoolean("rec.recommender.earlyStop");
        this.verbose = this.conf.getBoolean("rec.recommender.verbose", true);
        this.learnRate = this.conf.getFloat("rec.iterator.learnrate", Float.valueOf(0.01f)).floatValue();
        this.maxLearnRate = this.conf.getFloat("rec.iterator.learnrate.maximum", Float.valueOf(1000.0f)).floatValue();
        this.numFactors = this.conf.getInt("rec.factor.number", 10);
        this.reg = this.conf.getFloat("rec.tensor.regularization", Float.valueOf(0.01f)).floatValue();
        this.trainTensor = (SparseTensor)this.getDataModel().getTrainDataSet();
        this.testTensor = (SparseTensor)this.getDataModel().getTestDataSet();
        this.validTensor = (SparseTensor)this.getDataModel().getValidDataSet();
        int size = 0;
        double sum = 0.0;
        for (TensorEntry trainTensorEntry : this.trainTensor) {
            double rate = trainTensorEntry.get();
            this.maxRate = this.maxRate > rate ? this.maxRate : rate;
            this.minRate = this.minRate < rate ? this.minRate : rate;
            ++size;
            sum += rate;
        }
        this.globalMean = sum / (double)size;
        this.numDimensions = this.trainTensor.numDimensions();
        this.dimensions = this.trainTensor.dimensions();
        this.userMappingData = this.getDataModel().getUserMappingData();
        this.itemMappingData = this.getDataModel().getItemMappingData();
        this.numUsers = this.userMappingData.size();
        this.numItems = this.itemMappingData.size();
        this.allFeaturesMappingData = ((ArffDataModel)this.getDataModel()).getAllFeaturesMappingData();
        this.userDimension = this.trainTensor.getUserDimension();
        this.itemDimension = this.trainTensor.getItemDimension();
    }

    @Override
    public void recommend(RecommenderContext context) throws LibrecException {
        this.context = context;
        this.setup();
        this.LOG.info("Job Setup completed.");
        this.trainModel();
        this.LOG.info("Job Train completed.");
        this.recommendedList = this.recommend();
        this.LOG.info("Job End.");
        this.cleanup();
    }

    protected abstract void trainModel() throws LibrecException;

    protected RecommendedList recommend() throws LibrecException {
        this.recommendedList = this.isRanking && this.topN > 0 ? this.recommendRank() : this.recommendRating();
        return this.recommendedList;
    }

    protected RecommendedList recommendRank() throws LibrecException {
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        return this.recommendedList;
    }

    protected RecommendedList recommendRating() throws LibrecException {
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        for (TensorEntry testTensorEntry : this.testTensor) {
            int[] keys = testTensorEntry.keys();
            int userIdx = testTensorEntry.key(this.userDimension);
            int itemIdx = testTensorEntry.key(this.itemDimension);
            double predictRating = this.predict(keys, true);
            if (Double.isNaN(predictRating)) {
                predictRating = this.globalMean;
            }
            this.recommendedList.addUserItemIdx(userIdx, itemIdx, predictRating);
        }
        return this.recommendedList;
    }

    protected abstract double predict(int[] var1) throws LibrecException;

    protected double predict(int[] keys, boolean bound) throws LibrecException {
        double predictRating = this.predict(keys);
        if (bound) {
            if (predictRating > this.maxRate) {
                predictRating = this.maxRate;
            } else if (predictRating < this.minRate) {
                predictRating = this.minRate;
            }
        }
        return predictRating;
    }

    protected boolean isConverged(int iter) throws LibrecException {
        float delta_loss = (float)(this.lastLoss - this.loss);
        if (this.verbose) {
            String recName = this.getClass().getSimpleName().toString();
            String info = recName + " iter " + iter + ": loss = " + this.loss + ", delta_loss = " + delta_loss;
            this.LOG.info(info);
        }
        if (Double.isNaN(this.loss) || Double.isInfinite(this.loss)) {
            throw new LibrecException("Loss = NaN or Infinity: current settings does not fit the recommender! Change the settings and try again!");
        }
        boolean converged = (double)Math.abs(delta_loss) < 1.0E-5;
        return converged;
    }

    protected void updateLRate(int iter) {
        if ((double)this.learnRate < 0.0) {
            return;
        }
        if (this.isBoldDriver && iter > 1) {
            this.learnRate = Math.abs(this.lastLoss) > Math.abs(this.loss) ? this.learnRate * 1.05f : this.learnRate * 0.5f;
        } else if (this.decay > 0.0f && this.decay < 1.0f) {
            this.learnRate *= this.decay;
        }
        if (this.maxLearnRate > 0.0f && this.learnRate > this.maxLearnRate) {
            this.learnRate = this.maxLearnRate;
        }
        this.lastLoss = this.loss;
    }

    protected void cleanup() throws LibrecException {
    }

    @Override
    public double evaluate(RecommenderEvaluator evaluator) throws LibrecException {
        return 0.0;
    }

    @Override
    public Map<Measure.MeasureValue, Double> evaluateMap() throws LibrecException {
        return null;
    }

    @Override
    public DataModel getDataModel() {
        return this.context.getDataModel();
    }

    @Override
    public void loadModel(String filePath) {
    }

    @Override
    public void saveModel(String filePath) {
    }

    @Override
    public List<RecommendedItem> getRecommendedList() {
        return null;
    }

    @Override
    public void setContext(RecommenderContext context) {
        this.context = context;
    }
}

