/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import net.librec.common.LibrecException;
import net.librec.data.convertor.appender.SocialDataAppender;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.MatrixFactorizationRecommender;

public abstract class SocialRecommender
extends MatrixFactorizationRecommender {
    protected SparseMatrix socialMatrix;
    protected float regSocial;

    @Override
    public void setup() throws LibrecException {
        super.setup();
        this.regSocial = this.conf.getFloat("rec.social.regularization", Float.valueOf(0.01f)).floatValue();
        this.socialMatrix = ((SocialDataAppender)this.getDataModel().getDataAppender()).getUserAppender();
    }

    @Override
    protected double predict(int userIdx, int itemIdx, boolean bounded) throws LibrecException {
        double predictRating = this.predict(userIdx, itemIdx);
        if (bounded) {
            return this.denormalize(Maths.logistic(predictRating));
        }
        return predictRating;
    }

    protected double denormalize(double predictRating) {
        return this.minRate + predictRating * (this.maxRate - this.minRate);
    }

    protected double normalize(double rating) {
        return (rating - this.minRate) / (this.maxRate - this.minRate);
    }
}

