/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import com.google.common.collect.HashBasedTable;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.SparseTensor;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.TensorEntry;
import net.librec.math.structure.VectorEntry;
import net.librec.recommender.AbstractRecommender;
import net.librec.recommender.item.RecommendedItemList;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FactorizationMachineRecommender
extends AbstractRecommender {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected SparseTensor trainTensor;
    protected SparseTensor testTensor;
    protected SparseTensor validTensor;
    protected double w0;
    protected int p;
    protected int k;
    protected int n;
    protected DenseVector W;
    protected DenseMatrix V;
    protected DenseMatrix Q;
    protected float regW0;
    protected float regW;
    protected float regF;
    protected int numFactors;
    protected int numIterations;

    @Override
    protected void setup() throws LibrecException {
        this.conf = this.context.getConf();
        this.isRanking = this.conf.getBoolean("rec.recommender.isranking");
        if (this.isRanking) {
            this.topN = this.conf.getInt("rec.recommender.ranking.topn", 5);
        }
        this.earlyStop = this.conf.getBoolean("rec.recommender.earlyStop");
        this.numIterations = this.conf.getInt("rec.iterator.maximum");
        this.trainTensor = (SparseTensor)this.getDataModel().getTrainDataSet();
        this.testTensor = (SparseTensor)this.getDataModel().getTestDataSet();
        this.validTensor = (SparseTensor)this.getDataModel().getValidDataSet();
        this.userMappingData = this.getDataModel().getUserMappingData();
        this.itemMappingData = this.getDataModel().getItemMappingData();
        this.numUsers = this.userMappingData.size();
        this.numItems = this.itemMappingData.size();
        this.globalMean = this.trainTensor.mean();
        this.maxRate = this.conf.getDouble("rec.recommender.maxrate", 12.0);
        this.minRate = this.conf.getDouble("rec.recommender.minrate", 0.0);
        for (int dim = 0; dim < this.trainTensor.numDimensions; ++dim) {
            this.p += this.trainTensor.dimensions[dim];
        }
        this.n = this.trainTensor.size();
        this.numFactors = this.k = this.conf.getInt("rec.factor.number").intValue();
        this.w0 = 0.0;
        this.W = new DenseVector(this.p);
        this.W.init(0.0);
        this.V = new DenseMatrix(this.p, this.k);
        this.V.init(0.0, 0.1);
        this.regW0 = this.conf.getFloat("rec.fm.regw0", Float.valueOf(0.01f)).floatValue();
        this.regW = this.conf.getFloat("rec.fm.regW", Float.valueOf(0.01f)).floatValue();
        this.regF = this.conf.getFloat("rec.fm.regF", Float.valueOf(10.0f)).floatValue();
    }

    protected double predict(int userId, int itemId, SparseVector x) throws LibrecException {
        double res = 0.0;
        res += this.w0;
        for (VectorEntry ve : x) {
            double val = ve.get();
            int ind = ve.index();
            res += val * this.W.get(ind);
        }
        for (int f = 1; f < this.k; ++f) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (VectorEntry ve : x) {
                double xi = ve.get();
                int i = ve.index();
                double vif = this.V.get(i, f);
                sum1 += vif * xi;
                sum2 += vif * vif * xi * xi;
            }
            res += (sum1 * sum1 - sum2) / 2.0;
        }
        return res;
    }

    protected double predict(int userId, int itemId, SparseVector x, boolean bound) throws LibrecException {
        double pred = this.predict(userId, itemId, x);
        if (bound) {
            if (pred > this.maxRate) {
                pred = this.maxRate;
            }
            if (pred < this.minRate) {
                pred = this.minRate;
            }
        }
        return pred;
    }

    @Override
    protected RecommendedList recommendRating() throws LibrecException {
        this.testMatrix = this.testTensor.rateMatrix();
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        HashBasedTable<Integer, Integer, Double> ratingMapping = HashBasedTable.create();
        int userDimension = this.testTensor.getUserDimension();
        int itemDimension = this.testTensor.getItemDimension();
        for (TensorEntry tensorEntry : this.testTensor) {
            SparseVector featureVector;
            int[] entryKeys = tensorEntry.keys();
            double predictRating = this.predict(entryKeys[userDimension], entryKeys[itemDimension], featureVector = this.tenserKeysToFeatureVector(entryKeys), true);
            if (Double.isNaN(predictRating)) {
                predictRating = this.globalMean;
            }
            int[] userItemInd = this.getUserItemIndex(featureVector);
            int userIdx = userItemInd[0];
            int itemIdx = userItemInd[1];
            if (ratingMapping.contains(userIdx, itemIdx)) continue;
            ratingMapping.put(userIdx, itemIdx, predictRating);
            this.recommendedList.addUserItemIdx(userIdx, itemIdx, predictRating);
        }
        return this.recommendedList;
    }

    private int[] getUserItemIndex(SparseVector x) {
        int[] inds = x.getIndex();
        int userInd = inds[0];
        int itemInd = inds[1] - this.numUsers;
        return new int[]{userInd, itemInd};
    }

    protected SparseVector tenserKeysToFeatureVector(int[] tenserKeys) {
        int capacity = this.p;
        int[] index = new int[tenserKeys.length];
        double[] data = new double[tenserKeys.length];
        int colPrefix = 0;
        for (int i = 0; i < tenserKeys.length; ++i) {
            data[i] = 1.0;
            int n = i;
            index[n] = index[n] + (colPrefix + tenserKeys[i]);
            colPrefix += this.trainTensor.dimensions[i];
        }
        return new SparseVector(capacity, index, data);
    }
}

