/*
 * Decompiled with CFR 0.152.
 */
package net.librec.recommender;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.GenericRecommendedItem;
import net.librec.recommender.item.RecommendedItem;
import net.librec.recommender.item.RecommendedItemList;
import net.librec.recommender.item.RecommendedList;
import net.librec.recommender.item.UserItemRatingEntry;
import net.librec.util.ReflectionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRecommender
implements Recommender {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected boolean isRanking;
    protected int topN;
    protected Configuration conf;
    protected RecommenderContext context;
    protected SparseMatrix trainMatrix;
    protected SparseMatrix testMatrix;
    protected SparseMatrix validMatrix;
    protected RecommendedList recommendedList;
    protected int numUsers;
    protected int numItems;
    protected int numRates;
    protected double maxRate;
    protected double minRate;
    protected static List<Double> ratingScale;
    public BiMap<String, Integer> userMappingData;
    public BiMap<String, Integer> itemMappingData;
    protected double globalMean;
    protected boolean earlyStop;
    protected static boolean verbose;
    protected double loss;
    protected double lastLoss = 0.0;
    protected boolean isBoldDriver;
    protected float decay;

    protected void setup() throws LibrecException {
        this.conf = this.context.getConf();
        this.isRanking = this.conf.getBoolean("rec.recommender.isranking");
        if (this.isRanking) {
            this.topN = this.conf.getInt("rec.recommender.ranking.topn", 10);
            if (this.topN <= 0) {
                throw new IndexOutOfBoundsException("rec.recommender.ranking.topn should be more than 0!");
            }
        }
        this.earlyStop = this.conf.getBoolean("rec.recommender.earlystop", false);
        verbose = this.conf.getBoolean("rec.recommender.verbose", true);
        this.trainMatrix = (SparseMatrix)this.getDataModel().getTrainDataSet();
        this.testMatrix = (SparseMatrix)this.getDataModel().getTestDataSet();
        this.validMatrix = (SparseMatrix)this.getDataModel().getValidDataSet();
        this.userMappingData = this.getDataModel().getUserMappingData();
        this.itemMappingData = this.getDataModel().getItemMappingData();
        this.numUsers = this.trainMatrix.numRows();
        this.numItems = this.trainMatrix.numColumns();
        this.numRates = this.trainMatrix.size();
        ratingScale = new ArrayList<Double>(this.trainMatrix.getValueSet());
        Collections.sort(ratingScale);
        this.maxRate = Collections.max(this.trainMatrix.getValueSet());
        this.minRate = Collections.min(this.trainMatrix.getValueSet());
        if (this.minRate == this.maxRate) {
            this.minRate = 0.0;
        }
        this.globalMean = this.trainMatrix.mean();
        int[] numDroppedItemsArray = new int[this.numUsers];
        int maxNumTestItemsByUser = 0;
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            numDroppedItemsArray[userIdx] = this.numItems - this.trainMatrix.rowSize(userIdx);
            int numTestItemsByUser = this.testMatrix.rowSize(userIdx);
            maxNumTestItemsByUser = maxNumTestItemsByUser < numTestItemsByUser ? numTestItemsByUser : maxNumTestItemsByUser;
        }
        this.conf.setInts("rec.eval.auc.dropped.num", numDroppedItemsArray);
        this.conf.setInt("rec.eval.item.test.maxnum", maxNumTestItemsByUser);
    }

    protected abstract void trainModel() throws LibrecException;

    @Override
    public void recommend(RecommenderContext context) throws LibrecException {
        this.context = context;
        this.setup();
        this.LOG.info("Job Setup completed.");
        this.trainModel();
        this.LOG.info("Job Train completed.");
        this.recommendedList = this.recommend();
        this.LOG.info("Job End.");
        this.cleanup();
    }

    protected RecommendedList recommend() throws LibrecException {
        this.recommendedList = this.isRanking && this.topN > 0 ? this.recommendRank() : this.recommendRating();
        return this.recommendedList;
    }

    protected RecommendedList recommendRank() throws LibrecException {
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        for (int userIdx = 0; userIdx < this.numUsers; ++userIdx) {
            Set<Integer> itemSet = this.trainMatrix.getColumnsSet(userIdx);
            for (int itemIdx = 0; itemIdx < this.numItems; ++itemIdx) {
                double predictRating;
                if (itemSet.contains(itemIdx) || Double.isNaN(predictRating = this.predict(userIdx, itemIdx))) continue;
                this.recommendedList.addUserItemIdx(userIdx, itemIdx, predictRating);
            }
            this.recommendedList.topNRankItemsByUser(userIdx, this.topN);
        }
        if (this.recommendedList.size() == 0) {
            throw new IndexOutOfBoundsException("No item is recommended, there is something error in the recommendation algorithm! Please check it!");
        }
        return this.recommendedList;
    }

    protected RecommendedList recommendRating() throws LibrecException {
        this.recommendedList = new RecommendedItemList(this.numUsers - 1, this.numUsers);
        for (MatrixEntry matrixEntry : this.testMatrix) {
            int itemIdx;
            int userIdx = matrixEntry.row();
            double predictRating = this.predict(userIdx, itemIdx = matrixEntry.column(), true);
            if (Double.isNaN(predictRating)) {
                predictRating = this.globalMean;
            }
            this.recommendedList.addUserItemIdx(userIdx, itemIdx, predictRating);
        }
        return this.recommendedList;
    }

    protected abstract double predict(int var1, int var2) throws LibrecException;

    protected double predict(int userIdx, int itemIdx, boolean bound) throws LibrecException {
        double predictRating = this.predict(userIdx, itemIdx);
        if (bound) {
            if (predictRating > this.maxRate) {
                predictRating = this.maxRate;
            } else if (predictRating < this.minRate) {
                predictRating = this.minRate;
            }
        }
        return predictRating;
    }

    @Override
    public double evaluate(RecommenderEvaluator evaluator) throws LibrecException {
        return evaluator.evaluate(this.context, this.recommendedList);
    }

    @Override
    public Map<Measure.MeasureValue, Double> evaluateMap() throws LibrecException {
        HashMap<Measure.MeasureValue, Double> evaluatedMap = new HashMap<Measure.MeasureValue, Double>();
        List<Measure.MeasureValue> measureValueList = Measure.getMeasureEnumList(this.isRanking, this.topN);
        if (measureValueList != null) {
            for (Measure.MeasureValue measureValue : measureValueList) {
                RecommenderEvaluator evaluator = ReflectionUtil.newInstance(measureValue.getMeasure().getEvaluatorClass());
                if (this.isRanking && measureValue.getTopN() != null && measureValue.getTopN() > 0) {
                    evaluator.setTopN(measureValue.getTopN());
                }
                double evaluatedValue = evaluator.evaluate(this.context, this.recommendedList);
                evaluatedMap.put(measureValue, evaluatedValue);
            }
        }
        return evaluatedMap;
    }

    protected void cleanup() throws LibrecException {
    }

    @Override
    public void loadModel(String filePath) {
    }

    @Override
    public void saveModel(String filePath) {
    }

    protected RecommenderContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(RecommenderContext context) {
        this.context = context;
    }

    @Override
    public DataModel getDataModel() {
        return this.context.getDataModel();
    }

    @Override
    public List<RecommendedItem> getRecommendedList() {
        if (this.recommendedList != null && this.recommendedList.size() > 0) {
            ArrayList<RecommendedItem> userItemList = new ArrayList<RecommendedItem>();
            Iterator<UserItemRatingEntry> recommendedEntryIter = this.recommendedList.entryIterator();
            if (this.userMappingData != null && this.userMappingData.size() > 0 && this.itemMappingData != null && this.itemMappingData.size() > 0) {
                BiMap<Integer, String> userMappingInverse = this.userMappingData.inverse();
                BiMap<Integer, String> itemMappingInverse = this.itemMappingData.inverse();
                while (recommendedEntryIter.hasNext()) {
                    UserItemRatingEntry userItemRatingEntry = recommendedEntryIter.next();
                    if (userItemRatingEntry == null) continue;
                    String userId = (String)userMappingInverse.get(userItemRatingEntry.getUserIdx());
                    String itemId = (String)itemMappingInverse.get(userItemRatingEntry.getItemIdx());
                    if (!StringUtils.isNotBlank(userId) || !StringUtils.isNotBlank(itemId)) continue;
                    userItemList.add(new GenericRecommendedItem(userId, itemId, userItemRatingEntry.getValue()));
                }
                return userItemList;
            }
        }
        return null;
    }

    protected boolean isConverged(int iter) throws LibrecException {
        float delta_loss = (float)(this.lastLoss - this.loss);
        if (verbose) {
            String recName = this.getClass().getSimpleName().toString();
            String info = recName + " iter " + iter + ": loss = " + this.loss + ", delta_loss = " + delta_loss;
            this.LOG.info(info);
        }
        if (Double.isNaN(this.loss) || Double.isInfinite(this.loss)) {
            throw new LibrecException("Loss = NaN or Infinity: current settings does not fit the recommender! Change the settings and try again!");
        }
        boolean converged = (double)Math.abs(delta_loss) < 1.0E-5;
        return converged;
    }

    static {
        verbose = true;
    }
}

