/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.librec.math.algorithm.Stats;
import net.librec.math.structure.DenseVector;
import net.librec.math.structure.VectorEntry;

public class SparseVector
implements Iterable<VectorEntry>,
Serializable {
    private static final long serialVersionUID = 1151609203685872657L;
    static final float DEFAULT_COMPRESS_FACTOR = 0.75f;
    static final float DEFAULT_LOAD_FACTOR = 0.375f;
    protected int capacity;
    protected double[] data;
    protected int[] index;
    protected int count;
    protected int zeroCount = 0;
    protected int zeroFirstIndex;
    protected boolean autoCompress = true;

    public SparseVector(int capcity) {
        this.capacity = capcity;
        this.data = new double[0];
        this.count = 0;
        this.index = new int[0];
        this.zeroFirstIndex = 0;
    }

    public SparseVector(int capcity, int dataLength) {
        this.capacity = capcity;
        this.data = new double[dataLength];
        this.count = 0;
        this.index = new int[dataLength];
        this.zeroFirstIndex = 0;
    }

    public SparseVector(int capcity, double[] array) {
        this(capcity);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0.0) continue;
            this.set(i, array[i]);
        }
        this.zeroFirstIndex = this.count;
    }

    public SparseVector(int capacity, int[] index, double[] data) {
        this(capacity, index, data, 0, index.length - 1);
    }

    public SparseVector(int capacity, int[] index, double[] data, int startIdx, int endIdx) {
        this.capacity = capacity;
        int length = endIdx - startIdx + 1;
        this.index = new int[length];
        this.data = new double[length];
        int idxData = 0;
        for (int idx = startIdx; idx <= endIdx; ++idx) {
            if (data[idx] == 0.0) continue;
            this.data[idxData] = data[idx];
            this.index[idxData] = index[idx];
            ++idxData;
            ++this.count;
        }
        this.zeroCount = 0;
        this.zeroFirstIndex = this.count;
    }

    public SparseVector(SparseVector sv) {
        this(sv.capacity, sv.data);
    }

    public boolean contains(int idx) {
        return Arrays.binarySearch(this.index, 0, this.count, idx) >= 0;
    }

    public double[] getData() {
        int nonZeroCount = this.count - this.zeroCount;
        double[] res = new double[nonZeroCount];
        int idx = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == 0.0) continue;
            res[idx++] = this.data[i];
        }
        return res;
    }

    public int[] getIndex() {
        int nonZeroCount = this.count - this.zeroCount;
        int[] res = new int[nonZeroCount];
        int idx = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == 0.0) continue;
            res[idx++] = this.index[i];
        }
        return res;
    }

    public List<Integer> getIndexList() {
        ArrayList<Integer> res = new ArrayList<Integer>((int)((double)this.count * 1.5));
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == 0.0) continue;
            res.add(this.index[i]);
        }
        return res;
    }

    public Set<Integer> getIndexSet() {
        HashSet<Integer> res = new HashSet<Integer>((int)((double)this.count * 1.5));
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] == 0.0) continue;
            res.add(this.index[i]);
        }
        return res;
    }

    public int getCount() {
        return this.count;
    }

    public void set(int idx, double val) {
        this.check(idx);
        int i = this.getIndex(idx);
        this.data[i] = val;
        if (val == 0.0) {
            ++this.zeroCount;
        }
    }

    public void add(int idx, double val) {
        int i;
        this.check(idx);
        int n = i = this.getIndex(idx);
        this.data[n] = this.data[n] + val;
        if (this.data[i] == 0.0) {
            ++this.zeroCount;
        }
    }

    public void append(int idx, double val) {
        this.check(idx);
        if (val == 0.0) {
            return;
        }
        int[] newIndex = this.index;
        double[] newData = this.data;
        if (++this.count > this.data.length) {
            int newLength = this.data.length != 0 ? this.data.length << 1 : 1;
            newIndex = new int[newLength];
            newData = new double[newLength];
            System.arraycopy(this.index, 0, newIndex, 0, this.data.length);
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
        }
        newIndex[this.count - 1] = idx;
        newData[this.count - 1] = val;
        this.index = newIndex;
        this.data = newData;
    }

    public void compress() {
        for (int idx = this.zeroFirstIndex + 1; idx < this.count; ++idx) {
            if (this.data[idx] == 0.0) continue;
            this.data[this.zeroFirstIndex] = this.data[idx];
            this.index[this.zeroFirstIndex] = this.index[idx];
            ++this.zeroFirstIndex;
        }
        this.count = this.zeroFirstIndex;
        this.zeroCount = 0;
    }

    public double get(int idx) {
        this.check(idx);
        int i = Arrays.binarySearch(this.index, 0, this.count, idx);
        return i >= 0 ? this.data[i] : 0.0;
    }

    public double inner(SparseVector vec) {
        assert (this.capacity == vec.capacity);
        double res = 0.0;
        for (VectorEntry entry : this) {
            res += entry.get() * vec.get(entry.index());
        }
        return res;
    }

    public double inner(DenseVector vec) {
        assert (this.capacity == vec.size);
        double res = 0.0;
        for (VectorEntry entry : this) {
            res += entry.get() * vec.get(entry.index());
        }
        return res;
    }

    public double sum() {
        return Stats.sum(this.data);
    }

    public double mean() {
        return this.sum() / (double)this.size();
    }

    public int size() {
        return this.count - this.zeroCount;
    }

    protected void check(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("index is negative (" + idx + ")");
        }
        if (idx >= this.capacity) {
            throw new IndexOutOfBoundsException("index >= size (" + idx + " >= " + this.capacity + ")");
        }
    }

    private int getIndex(int idx) {
        int i = Arrays.binarySearch(this.index, 0, this.count, idx);
        if (i >= 0 && this.index[i] == idx) {
            return i;
        }
        int[] newIndex = this.index;
        double[] newData = this.data;
        i = -(i + 1);
        if (++this.count > this.data.length) {
            int newLength = this.data.length != 0 ? this.data.length << 1 : 1;
            newIndex = new int[newLength];
            newData = new double[newLength];
            System.arraycopy(this.index, 0, newIndex, 0, i);
            System.arraycopy(this.data, 0, newData, 0, i);
        }
        System.arraycopy(this.index, i, newIndex, i + 1, this.count - i - 1);
        System.arraycopy(this.data, i, newData, i + 1, this.count - i - 1);
        newIndex[i] = idx;
        newData[i] = 0.0;
        this.index = newIndex;
        this.data = newData;
        return i;
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new SparseVecIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d\t%d\n", this.capacity, this.count));
        for (VectorEntry ve : this) {
            if (ve.get() == 0.0) continue;
            sb.append(String.format("%d\t%f\n", ve.index(), ve.get()));
        }
        return sb.toString();
    }

    public Map<Integer, Double> toMap() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i = 0; i < this.count; ++i) {
            int idx = this.index[i];
            double val = this.data[i];
            if (val == 0.0) continue;
            map.put(idx, val);
        }
        return map;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private class SparseVecEntry
    implements VectorEntry {
        private int cursor;

        private SparseVecEntry() {
        }

        public void update(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public int index() {
            return SparseVector.this.index[this.cursor];
        }

        @Override
        public double get() {
            return SparseVector.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            SparseVector.this.data[this.cursor] = value;
            if (value == 0.0) {
                ++SparseVector.this.zeroCount;
            }
        }
    }

    private class SparseVecIterator
    implements Iterator<VectorEntry> {
        private int cursor;
        private final SparseVecEntry entry;

        private SparseVecIterator() {
            this.entry = new SparseVecEntry();
            this.cursor = 0;
            this.entry.update(this.cursor);
            while (this.cursor + 1 < SparseVector.this.count && this.entry.get() == 0.0) {
                ++this.cursor;
                this.entry.update(this.cursor);
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SparseVector.this.count;
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.cursor);
            ++this.cursor;
            SparseVecEntry tempEntry = new SparseVecEntry();
            tempEntry.update(this.cursor);
            while (this.hasNext() && tempEntry.get() == 0.0) {
                ++this.cursor;
                tempEntry.update(this.cursor);
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

