/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.structure;

import java.io.Serializable;
import net.librec.math.algorithm.Randoms;
import net.librec.math.algorithm.Stats;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.util.StringUtil;

public class DenseVector
implements Serializable {
    private static final long serialVersionUID = -2930574547913792430L;
    protected int size;
    protected double[] data;

    public DenseVector(int size) {
        this.size = size;
        this.data = new double[size];
    }

    public DenseVector(double[] array) {
        this(array, true);
    }

    public DenseVector(double[] array, boolean deep) {
        this.size = array.length;
        if (deep) {
            this.data = new double[array.length];
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = array[i];
            }
        } else {
            this.data = array;
        }
    }

    public DenseVector(DenseVector vec) {
        this(vec.data);
    }

    public DenseVector clone() {
        return new DenseVector(this);
    }

    public void init(double mean, double sigma) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = Randoms.gaussian(mean, sigma);
        }
    }

    public void init() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = Randoms.uniform();
        }
    }

    public void init(double range) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = Randoms.uniform(0.0, range);
        }
    }

    public double get(int idx) {
        return this.data[idx];
    }

    public double[] getData() {
        return this.data;
    }

    public double mean() {
        return Stats.mean(this.data);
    }

    public double sum() {
        return Stats.sum(this.data);
    }

    public void set(int idx, double val) {
        this.data[idx] = val;
    }

    public void setAll(double val) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = val;
        }
    }

    public void add(int idx, double val) {
        int n = idx;
        this.data[n] = this.data[n] + val;
    }

    public void minus(int idx, double val) {
        int n = idx;
        this.data[n] = this.data[n] - val;
    }

    public DenseVector add(double val) {
        DenseVector result = new DenseVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.data[i] = this.data[i] + val;
        }
        return result;
    }

    public DenseVector addEqual(double val) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.data[n] = this.data[n] + val;
        }
        return this;
    }

    public DenseVector add(DenseVector vec) {
        assert (this.size == vec.size);
        DenseVector result = new DenseVector(this.size);
        for (int i = 0; i < result.size; ++i) {
            result.data[i] = this.data[i] + vec.data[i];
        }
        return result;
    }

    public DenseVector addEqual(DenseVector vec) {
        assert (this.size == vec.size);
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vec.data[i];
        }
        return this;
    }

    public DenseVector minus(double val) {
        DenseVector result = new DenseVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.data[i] = this.data[i] - val;
        }
        return result;
    }

    public DenseVector minusEqual(double val) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.data[n] = this.data[n] - val;
        }
        return this;
    }

    public DenseVector minus(DenseVector vec) {
        assert (this.size == vec.size);
        DenseVector result = new DenseVector(this.size);
        for (int i = 0; i < vec.size; ++i) {
            result.data[i] = this.data[i] - vec.data[i];
        }
        return result;
    }

    public DenseVector minusEqual(DenseVector vec) {
        assert (this.size == vec.size);
        for (int i = 0; i < vec.size; ++i) {
            int n = i;
            this.data[n] = this.data[n] - vec.data[i];
        }
        return this;
    }

    public DenseVector scale(double val) {
        DenseVector result = new DenseVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.data[i] = this.data[i] * val;
        }
        return result;
    }

    public DenseVector scaleEqual(double val) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.data[n] = this.data[n] * val;
        }
        return this;
    }

    public double inner(DenseVector vec) {
        assert (this.size == vec.size);
        double result = 0.0;
        for (int i = 0; i < vec.size; ++i) {
            result += this.get(i) * vec.get(i);
        }
        return result;
    }

    public double inner(SparseVector vec) {
        double result = 0.0;
        for (int j : vec.getIndex()) {
            result += vec.get(j) * this.get(j);
        }
        return result;
    }

    public DenseMatrix outer(DenseVector vec) {
        DenseMatrix mat = new DenseMatrix(this.size, vec.size);
        for (int i = 0; i < mat.numRows; ++i) {
            for (int j = 0; j < mat.numColumns; ++j) {
                mat.set(i, j, this.get(i) * vec.get(j));
            }
        }
        return mat;
    }

    public static DenseVector kroneckerProduct(DenseVector M, DenseVector N) {
        DenseVector res = new DenseVector(M.size * N.size);
        int i = 0;
        for (int m = 0; m < M.size; ++m) {
            double mVal = M.get(m);
            for (int n = 0; n < N.size; ++n) {
                res.set(i++, mVal * N.get(n));
            }
        }
        return res;
    }

    public String toString() {
        return StringUtil.toString(this.data);
    }

    public void setData(double[] data) {
        this.data = data;
    }
}

