/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;

public class Shuffle {
    public Shuffle(SparseMatrix sparseMatrix) {
        int size = sparseMatrix.size();
        sparseMatrix.isShuffle = true;
        sparseMatrix.shuffleRow = new int[size];
        sparseMatrix.shuffleCursor = new int[size];
        int i = 0;
        for (MatrixEntry me : sparseMatrix) {
            sparseMatrix.shuffleRow[i] = me.row();
            sparseMatrix.shuffleCursor[i] = i;
            ++i;
        }
        for (int k = size - 1; k > 0; ++k) {
            int j = (int)(Randoms.uniform(0.0, 1.0) * (double)k);
            int temp = sparseMatrix.shuffleRow[k];
            sparseMatrix.shuffleRow[k] = sparseMatrix.shuffleRow[j];
            sparseMatrix.shuffleRow[j] = temp;
            temp = sparseMatrix.shuffleCursor[k];
            sparseMatrix.shuffleCursor[k] = sparseMatrix.shuffleCursor[j];
            sparseMatrix.shuffleCursor[j] = temp;
        }
    }
}

