/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

import net.librec.math.algorithm.Maths;
import net.librec.math.structure.DenseMatrix;

public class SVD {
    private double[][] U;
    private double[][] V;
    private double[] sigma;
    private int m;
    private int n;

    public SVD(DenseMatrix mat) {
        int i;
        double t;
        int k;
        int j;
        DenseMatrix matClone = mat.clone();
        double[][] A = matClone.data;
        this.m = matClone.numRows;
        this.n = matClone.numColumns;
        int nu = Math.min(this.m, this.n);
        this.sigma = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.sigma[k2] = 0.0;
                for (i3 = k2; i3 < this.m; ++i3) {
                    this.sigma[k2] = Maths.hypot(this.sigma[k2], A[i3][k2]);
                }
                if (this.sigma[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.sigma[k2] = -this.sigma[k2];
                    }
                    for (i3 = k2; i3 < this.m; ++i3) {
                        double[] dArray = A[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.sigma[k2];
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.sigma[k2] = -this.sigma[k2];
            }
            for (j = k2 + 1; j < this.n; ++j) {
                if (k2 < nct & this.sigma[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i2 = k2; i2 < this.m; ++i2) {
                        t2 += A[i2][k2] * A[i2][j];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (i2 = k2; i2 < this.m; ++i2) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (k2 < nct) {
                for (i3 = k2; i3 < this.m; ++i3) {
                    this.U[i3][k2] = A[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i3 = k2 + 1; i3 < this.n; ++i3) {
                e[k2] = Maths.hypot(e[k2], e[i3]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i3 = k2 + 1;
                while (i3 < this.n) {
                    int n = i3++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m & e[k2] != 0.0) {
                for (i3 = k2 + 1; i3 < this.m; ++i3) {
                    work[i3] = 0.0;
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    for (int i4 = k2 + 1; i4 < this.m; ++i4) {
                        int n = i4;
                        work[n] = work[n] + e[j] * A[i4][j];
                    }
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (i2 = k2 + 1; i2 < this.m; ++i2) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * work[i2];
                    }
                }
            }
            for (i3 = k2 + 1; i3 < this.n; ++i3) {
                this.V[i3][k2] = e[i3];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.sigma[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.sigma[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        for (j = nct; j < nu; ++j) {
            for (int i5 = 0; i5 < this.m; ++i5) {
                this.U[i5][j] = 0.0;
            }
            this.U[j][j] = 1.0;
        }
        for (k = nct - 1; k >= 0; --k) {
            int i6;
            if (this.sigma[k] != 0.0) {
                for (int j2 = k + 1; j2 < nu; ++j2) {
                    t = 0.0;
                    for (i = k; i < this.m; ++i) {
                        t += this.U[i][k] * this.U[i][j2];
                    }
                    t = -t / this.U[k][k];
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = this.U[i];
                        int n = j2;
                        dArray[n] = dArray[n] + t * this.U[i][k];
                    }
                }
                for (i6 = k; i6 < this.m; ++i6) {
                    this.U[i6][k] = -this.U[i6][k];
                }
                this.U[k][k] = 1.0 + this.U[k][k];
                for (i6 = 0; i6 < k - 1; ++i6) {
                    this.U[i6][k] = 0.0;
                }
                continue;
            }
            for (i6 = 0; i6 < this.m; ++i6) {
                this.U[i6][k] = 0.0;
            }
            this.U[k][k] = 1.0;
        }
        for (k = this.n - 1; k >= 0; --k) {
            if (k < nrt & e[k] != 0.0) {
                for (int j3 = k + 1; j3 < nu; ++j3) {
                    t = 0.0;
                    for (i = k + 1; i < this.n; ++i) {
                        t += this.V[i][k] * this.V[i][j3];
                    }
                    t = -t / this.V[k + 1][k];
                    for (i = k + 1; i < this.n; ++i) {
                        double[] dArray = this.V[i];
                        int n = j3;
                        dArray[n] = dArray[n] + t * this.V[i][k];
                    }
                }
            }
            for (int i7 = 0; i7 < this.n; ++i7) {
                this.V[i7][k] = 0.0;
            }
            this.V[k][k] = 1.0;
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.sigma[k3]) + Math.abs(this.sigma[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.sigma[ks]) <= tiny + eps * t4)) continue;
                    this.sigma[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = Maths.hypot(this.sigma[j4], f);
                        cs = this.sigma[j4] / t5;
                        sn = f / t5;
                        this.sigma[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        for (i8 = 0; i8 < this.n; ++i8) {
                            t5 = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                            this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                            this.V[i8][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = Maths.hypot(this.sigma[j5], f);
                        cs = this.sigma[j5] / t5;
                        sn = f / t5;
                        this.sigma[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        for (i8 = 0; i8 < this.m; ++i8) {
                            t5 = cs * this.U[i8][j5] + sn * this.U[i8][k3 - 1];
                            this.U[i8][k3 - 1] = -sn * this.U[i8][j5] + cs * this.U[i8][k3 - 1];
                            this.U[i8][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.sigma[p - 1]), Math.abs(this.sigma[p - 2])), Math.abs(e[p - 2])), Math.abs(this.sigma[k3])), Math.abs(e[k3]));
                    double sp = this.sigma[p - 1] / scale;
                    double spm1 = this.sigma[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.sigma[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i9;
                        double t6 = Maths.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.sigma[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.sigma[j6];
                        g = sn * this.sigma[j6 + 1];
                        this.sigma[j6 + 1] = cs * this.sigma[j6 + 1];
                        for (i9 = 0; i9 < this.n; ++i9) {
                            t6 = cs * this.V[i9][j6] + sn * this.V[i9][j6 + 1];
                            this.V[i9][j6 + 1] = -sn * this.V[i9][j6] + cs * this.V[i9][j6 + 1];
                            this.V[i9][j6] = t6;
                        }
                        t6 = Maths.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.sigma[j6] = t6;
                        f = cs * e[j6] + sn * this.sigma[j6 + 1];
                        this.sigma[j6 + 1] = -sn * e[j6] + cs * this.sigma[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (j6 >= this.m - 1) continue;
                        for (i9 = 0; i9 < this.m; ++i9) {
                            t6 = cs * this.U[i9][j6] + sn * this.U[i9][j6 + 1];
                            this.U[i9][j6 + 1] = -sn * this.U[i9][j6] + cs * this.U[i9][j6 + 1];
                            this.U[i9][j6] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.sigma[k3] <= 0.0) {
                        this.sigma[k3] = this.sigma[k3] < 0.0 ? -this.sigma[k3] : 0.0;
                        for (int i10 = 0; i10 <= pp; ++i10) {
                            this.V[i10][k3] = -this.V[i10][k3];
                        }
                    }
                    while (k3 < pp && !(this.sigma[k3] >= this.sigma[k3 + 1])) {
                        int i11;
                        double t7 = this.sigma[k3];
                        this.sigma[k3] = this.sigma[k3 + 1];
                        this.sigma[k3 + 1] = t7;
                        if (k3 < this.n - 1) {
                            for (i11 = 0; i11 < this.n; ++i11) {
                                t7 = this.V[i11][k3 + 1];
                                this.V[i11][k3 + 1] = this.V[i11][k3];
                                this.V[i11][k3] = t7;
                            }
                        }
                        if (k3 < this.m - 1) {
                            for (i11 = 0; i11 < this.m; ++i11) {
                                t7 = this.U[i11][k3 + 1];
                                this.U[i11][k3 + 1] = this.U[i11][k3];
                                this.U[i11][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public DenseMatrix getU() {
        return new DenseMatrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public DenseMatrix getV() {
        return new DenseMatrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.sigma;
    }

    public DenseMatrix getS() {
        DenseMatrix res = new DenseMatrix(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            res.set(i, i, this.sigma[i]);
        }
        return res;
    }

    public double norm2() {
        return this.sigma[0];
    }

    public double cond() {
        return this.sigma[0] / this.sigma[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.sigma[0] * eps;
        int r = 0;
        for (int i = 0; i < this.sigma.length; ++i) {
            if (!(this.sigma[i] > tol)) continue;
            ++r;
        }
        return r;
    }
}

