/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.librec.common.LibrecException;
import net.librec.math.structure.DenseMatrix;
import net.librec.math.structure.SparseVector;

public class Randoms {
    private static Random r = new Random(System.currentTimeMillis());
    private static List<Object> _tempList = new ArrayList<Object>();

    public static int uniform(int range) {
        return Randoms.uniform(0, range);
    }

    public static void seed(long seed) {
        r = new Random(seed);
    }

    public static int uniform(int min, int max) {
        return min + r.nextInt(max - min);
    }

    public static double random() {
        return Randoms.uniform();
    }

    public static <T> T random(List<T> data) {
        int idx = Randoms.uniform(data.size());
        return data.get(idx);
    }

    public static double[] doubles(int size) {
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = Randoms.random();
        }
        return array;
    }

    public static double[] doubles(double min, double max, int size) {
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = Randoms.uniform(min, max);
        }
        return array;
    }

    public static double uniform() {
        return Randoms.uniform(0.0, 1.0);
    }

    public static double uniform(double min, double max) {
        return min + (max - min) * r.nextDouble();
    }

    public static boolean bernoulli(double p) {
        return Randoms.uniform() < p;
    }

    public static boolean bernoulli() {
        return Randoms.bernoulli(0.5);
    }

    public static double gaussian(double mu, double sigma) {
        return mu + sigma * r.nextGaussian();
    }

    public static double gamma(double alpha, double scale) {
        double w;
        double sign_u;
        double e;
        double q;
        double v;
        double v2;
        double v1;
        double v12;
        double rate = 1.0 / scale;
        if (alpha <= 0.0 || rate <= 0.0) {
            throw new IllegalArgumentException();
        }
        double b = 0.0;
        if (alpha < 1.0) {
            double gds;
            b = 1.0 + 0.36788794412 * alpha;
            while (true) {
                double p;
                if ((p = b * r.nextDouble()) <= 1.0) {
                    gds = Math.exp(Math.log(p) / alpha);
                    if (!(Math.log(r.nextDouble()) <= -gds)) continue;
                    return gds / rate;
                }
                gds = -Math.log((b - p) / alpha);
                if (Math.log(r.nextDouble()) <= (alpha - 1.0) * Math.log(gds)) break;
            }
            return gds / rate;
        }
        double ss = 0.0;
        double s = 0.0;
        double d = 0.0;
        if (alpha != -1.0) {
            ss = alpha - 0.5;
            s = Math.sqrt(ss);
            d = 5.656854249 - 12.0 * s;
        }
        while ((v12 = (v1 = 2.0 * r.nextDouble() - 1.0) * v1 + (v2 = 2.0 * r.nextDouble() - 1.0) * v2) > 1.0) {
        }
        double t = v1 * Math.sqrt(-2.0 * Math.log(v12) / v12);
        double x = s + 0.5 * t;
        double gds = x * x;
        if (t >= 0.0) {
            return gds / rate;
        }
        double u = r.nextDouble();
        if (d * u <= t * t * t) {
            return gds / rate;
        }
        double q0 = 0.0;
        double si = 0.0;
        double c = 0.0;
        if (alpha != -1.0) {
            double rr = 1.0 / alpha;
            double q9 = 1.71032E-4;
            double q8 = -4.701849E-4;
            double q7 = 6.053049E-4;
            double q6 = 3.340332E-4;
            double q5 = -3.349403E-4;
            double q4 = 0.0015746717;
            double q3 = 0.0079849875;
            double q2 = 0.0208333723;
            double q1 = 0.0416666664;
            q0 = ((((((((q9 * rr + q8) * rr + q7) * rr + q6) * rr + q5) * rr + q4) * rr + q3) * rr + q2) * rr + q1) * rr;
            if (alpha > 3.686) {
                if (alpha > 13.022) {
                    b = 1.77;
                    si = 0.75;
                    c = 0.1515 / s;
                } else {
                    b = 1.654 + 0.0076 * ss;
                    si = 1.68 / s + 0.275;
                    c = 0.062 / s + 0.024;
                }
            } else {
                b = 0.463 + s - 0.178 * ss;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.016 * s;
            }
        }
        double a9 = 0.104089866;
        double a8 = -0.112750886;
        double a7 = 0.11036831;
        double a6 = -0.124385581;
        double a5 = 0.142873973;
        double a4 = -0.166677482;
        double a3 = 0.199999867;
        double a2 = -0.249999949;
        double a1 = 0.333333333;
        if (x > 0.0) {
            v = t / (s + s);
            q = Math.abs(v) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v;
            if (Math.log(1.0 - u) <= q) {
                return gds / rate;
            }
        }
        double e7 = 2.47453E-4;
        double e6 = 0.001353826;
        double e5 = 0.008345522;
        double e4 = 0.041664508;
        double e3 = 0.166666848;
        double e2 = 0.499999994;
        double e1 = 1.0;
        do {
            e = -Math.log(r.nextDouble());
            u = r.nextDouble();
        } while ((t = b + e * si * (sign_u = (u = u + u - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (q = Math.abs(v = t / (s + s)) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v) <= 0.0 || !(c * u * sign_u <= (w = q > 0.5 ? Math.exp(q) - 1.0 : ((((((e7 * q + e6) * q + e5) * q + e4) * q + e3) * q + e2) * q + e1) * q) * Math.exp(e - 0.5 * t * t)));
        x = s + 0.5 * t;
        return x * x / rate;
    }

    public static DenseMatrix wishart(DenseMatrix scale, double df) throws LibrecException {
        int j;
        DenseMatrix A = scale.cholesky();
        if (A == null) {
            return null;
        }
        int p = scale.numRows();
        DenseMatrix z = new DenseMatrix(p, p);
        for (int i = 0; i < p; ++i) {
            for (int j2 = 0; j2 < p; ++j2) {
                z.set(i, j2, Randoms.gaussian(0.0, 1.0));
            }
        }
        SparseVector y = new SparseVector(p);
        for (int i = 0; i < p; ++i) {
            y.set(i, Randoms.gamma((df - (double)(i + 1)) / 2.0, 2.0));
        }
        DenseMatrix B = new DenseMatrix(p, p);
        B.set(0, 0, y.get(0));
        if (p > 1) {
            for (j = 1; j < p; ++j) {
                SparseVector zz = new SparseVector(j);
                for (int k = 0; k < j; ++k) {
                    zz.set(k, z.get(k, j));
                }
                B.set(j, j, y.get(j) + zz.inner(zz));
            }
            for (j = 1; j < p; ++j) {
                B.set(0, j, z.get(0, j) * Math.sqrt(y.get(0)));
                B.set(j, 0, B.get(0, j));
            }
        }
        if (p > 2) {
            for (j = 2; j < p; ++j) {
                for (int i = 1; i <= j - 1; ++i) {
                    SparseVector zki = new SparseVector(i);
                    SparseVector zkj = new SparseVector(i);
                    for (int k = 0; k <= i - 1; ++k) {
                        zki.set(k, z.get(k, i));
                        zkj.set(k, z.get(k, j));
                    }
                    B.set(i, j, z.get(i, j) * Math.sqrt(y.get(i)) + zki.inner(zkj));
                    B.set(j, i, B.get(i, j));
                }
            }
        }
        return A.transpose().mult(B).mult(A);
    }

    public static int poisson(double lambda) {
        int k = 0;
        double p = 1.0;
        double L = Math.exp(-lambda);
        do {
            ++k;
        } while ((p *= Randoms.uniform()) >= L);
        return k - 1;
    }

    public static double pareto(double alpha) {
        return Math.pow(1.0 - Randoms.uniform(), -1.0 / alpha) - 1.0;
    }

    public static double cauchy() {
        return Math.tan(Math.PI * (Randoms.uniform() - 0.5));
    }

    public static int discrete(double[] a) {
        double EPSILON = 1.0E-6;
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < 0.0) {
                throw new IllegalArgumentException("array entry " + i + " is negative: " + a[i]);
            }
            sum += a[i];
        }
        if (sum > 1.0 + EPSILON || sum < 1.0 - EPSILON) {
            throw new IllegalArgumentException("sum of array entries not equal to one: " + sum);
        }
        block1: while (true) {
            double r = Randoms.uniform();
            sum = 0.0;
            int i = 0;
            while (true) {
                if (i >= a.length) continue block1;
                if ((sum += a[i]) > r) {
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    public static double exp(double lambda) {
        return -Math.log(1.0 - Randoms.uniform()) / lambda;
    }

    public static int nextInt(int range, int ... exceptions) {
        return Randoms.nextInt(0, range, exceptions);
    }

    public static int nextInt(int min, int max, int ... exceptions) {
        int next;
        do {
            next = min + r.nextInt(max - min);
        } while (exceptions != null && exceptions.length > 0 && Arrays.binarySearch(exceptions, next) >= 0 || _tempList.contains(next));
        _tempList.add(next);
        return next;
    }

    public static int[] indexs(int size, int min, int max) {
        HashSet<Integer> used = new HashSet<Integer>();
        int[] index = new int[size];
        for (int i = 0; i < index.length; ++i) {
            int ind;
            while (used.contains(ind = Randoms.uniform(min, max))) {
            }
            index[i] = ind;
            used.add(ind);
        }
        return index;
    }

    public static void clearCache() {
        _tempList.clear();
    }

    public static int[] nextIntArray(int length, int range) throws Exception {
        return Randoms.nextIntArray(length, 0, range, null);
    }

    public static int[] nextIntArray(int length, int range, int ... exceptions) throws Exception {
        return Randoms.nextIntArray(length, 0, range, exceptions);
    }

    public static int[] nextIntArray(int length, int min, int max) throws Exception {
        return Randoms.nextIntArray(length, min, max, null);
    }

    public static int[] nextIntArray(int length, int min, int max, int ... exceptions) throws Exception {
        int maxLen = max - min;
        if (maxLen < length) {
            throw new Exception("The range is less than legth");
        }
        int[] index = new int[length];
        if (maxLen == length) {
            for (int i = 0; i < length; ++i) {
                index[i] = min + i;
            }
        } else {
            Randoms.clearCache();
            for (int i = 0; i < index.length; ++i) {
                index[i] = Randoms.nextInt(min, max, exceptions);
            }
            Arrays.sort(index);
        }
        return index;
    }

    public static List<Integer> randInts(int length, int min, int max) throws Exception {
        int len = max - min;
        if (len < length) {
            throw new Exception("The range is less than legth");
        }
        HashSet<Integer> ints = new HashSet<Integer>();
        do {
            int rand = min + r.nextInt(max - min);
            ints.add(rand);
        } while (ints.size() < length);
        ArrayList<Integer> res = new ArrayList<Integer>(ints);
        Collections.sort(res);
        return res;
    }

    public static double[] randProbs(int size) {
        int i;
        if (size < 1) {
            throw new IllegalArgumentException("The size param must be greate than zero");
        }
        double[] pros = new double[size];
        int sum = 0;
        for (i = 0; i < pros.length; ++i) {
            pros[i] = r.nextInt(size) + 1;
            sum = (int)((double)sum + pros[i]);
        }
        for (i = 0; i < pros.length; ++i) {
            pros[i] = pros[i] / (double)sum;
        }
        return pros;
    }

    public static int[] ints(int range, int size) {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = Randoms.uniform(range);
        }
        return data;
    }

    public static int[] ints(int min, int max, int size) {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = Randoms.uniform(min, max);
        }
        return data;
    }

    public static List<Double> list(int size) {
        return Randoms.list(size, 0, 1, false);
    }

    public static List<Double> list(int size, int min, int max) {
        return Randoms.list(size, min, max, false);
    }

    public static List<Double> list(int size, int min, int max, boolean isInteger) {
        ArrayList<Double> list = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            if (isInteger) {
                list.add((double)Randoms.uniform(min, max) + 0.0);
                continue;
            }
            list.add(Randoms.uniform((double)min + 0.0, (double)max + 0.0));
        }
        return list;
    }

    public static List<Integer> permute(int min, int max) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int len = max - min + 1;
        for (int i = 0; i < len; ++i) {
            int index;
            while (list.contains(index = Randoms.uniform(min, max + 1))) {
            }
            list.add(index);
        }
        return list;
    }
}

