/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

import java.util.Collection;

public class Maths {
    public static final double golden_ratio = 0.5 * (Math.sqrt(5.0) + 1.0);
    public static final double zero = 1.0E-6;

    public static boolean isEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public static boolean isNumber(String string) {
        return string.matches("^\\d+$");
    }

    public static boolean isNumeric(String string) {
        return string.matches("^[-+]?\\d+(\\.\\d+)?$");
    }

    public static boolean isNumberWith2Decimals(String string) {
        return string.matches("^\\d+\\.\\d{2}$");
    }

    public static boolean isInt(double data) {
        return Maths.isEqual(data, Math.floor(data)) && !Double.isInfinite(data);
    }

    public static int factorial(int n) {
        if (n < 0) {
            return 0;
        }
        if (n == 0 || n == 1) {
            return 1;
        }
        return n * Maths.factorial(n - 1);
    }

    public static double ln(double n) {
        return Math.log(n);
    }

    public static double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public static double logSum(double log_a, double log_b) {
        double v = log_a < log_b ? log_b + Math.log(1.0 + Math.exp(log_a - log_b)) : log_a + Math.log(1.0 + Math.exp(log_b - log_a));
        return v;
    }

    public static double logistic(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    protected double gaussian(double x, double mu, double sigma) {
        return Math.exp(-0.5 * Math.pow(x - mu, 2.0) / (sigma * sigma));
    }

    public static double[] softmax(double[] x) throws Exception {
        int i;
        double[] expx = new double[x.length];
        double max = x[0];
        for (i = 1; i < x.length; ++i) {
            max = Math.max(x[i], max);
        }
        for (i = 0; i < x.length; ++i) {
            expx[i] = Math.exp(x[i] - max);
        }
        return Maths.norm(expx);
    }

    public static double[] norm(double[] x) throws Exception {
        double sm = Maths.sum(x);
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = x[i] / sm;
        }
        return result;
    }

    public static double sum(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return sum;
    }

    public static double logisticGradientValue(double x) {
        return Maths.logistic(x) * Maths.logistic(-x);
    }

    public static double normalize(double x, double min, double max) {
        if (max > min) {
            return (x - min) / (max - min);
        }
        if (Maths.isEqual(min, max)) {
            return x / max;
        }
        return x;
    }

    public static int fabonacci(int n) {
        assert (n > 0);
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        return Maths.fabonacci(n - 1) + Maths.fabonacci(n - 2);
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return Maths.gcd(b, a % b);
    }

    public static int lcm(int a, int b) {
        if (a > 0 && b > 0) {
            return (int)((0.0 + (double)(a * b)) / (double)Maths.gcd(a, b));
        }
        return 0;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (!Maths.isEqual(b, 0.0)) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double mean(Collection<? extends Number> data) {
        double sum = 0.0;
        int count = 0;
        for (Number number : data) {
            if (Double.isNaN(number.doubleValue())) continue;
            sum += number.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }
}

