/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

public class KernelSmoothing {
    public static final int TRIANGULAR_KERNEL = 201;
    public static final int UNIFORM_KERNEL = 202;
    public static final int EPANECHNIKOV_KERNEL = 203;
    public static final int GAUSSIAN_KERNEL = 204;

    public static double kernelize(double sim, double width, int kernelType) {
        double dist = 1.0 - sim;
        if (kernelType == 201) {
            return Math.max(1.0 - dist / width, 0.0);
        }
        if (kernelType == 202) {
            return dist < width ? 1.0 : 0.0;
        }
        if (kernelType == 203) {
            return Math.max(0.75 * (1.0 - Math.pow(dist / width, 2.0)), 0.0);
        }
        if (kernelType == 204) {
            return 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-0.5 * Math.pow(dist / width, 2.0));
        }
        return Math.max(1.0 - dist / width, 0.0);
    }
}

