/*
 * Decompiled with CFR 0.152.
 */
package net.librec.math.algorithm;

public class Gamma {
    private static final double small = 1.0E-6;
    private static final double large = 9.5;
    private static final double d1 = -0.5772156649015329;
    private static final double d2 = Math.pow(Math.PI, 2.0) / 6.0;
    private static final double s3 = 0.08333333333333333;
    private static final double s4 = 0.008333333333333333;
    private static final double s5 = 0.003968253968253968;
    private static final double s6 = 0.004166666666666667;
    private static final double s7 = 0.007575757575757576;

    public static double logGamma(double x) {
        double tmp = (x - 0.5) * Math.log(x + 4.5) - (x + 4.5);
        double ser = 1.0 + 76.18009173 / (x + 0.0) - 86.50532033 / (x + 1.0) + 24.01409822 / (x + 2.0) - 1.231739516 / (x + 3.0) + 0.00120858003 / (x + 4.0) - 5.36382E-6 / (x + 5.0);
        return tmp + Math.log(ser * Math.sqrt(Math.PI * 2));
    }

    public static double gamma(double x) {
        return Math.exp(Gamma.logGamma(x));
    }

    public static double digamma(double x) {
        double y = 0.0;
        double r = 0.0;
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x < 0.0) {
            y = Gamma.digamma(-x + 1.0) + Math.PI * (1.0 / Math.tan(-Math.PI * x));
            return y;
        }
        if (x <= 1.0E-6) {
            y = y + -0.5772156649015329 - 1.0 / x + d2 * x;
            return y;
        }
        while (x > 1.0E-6 && x < 9.5) {
            y -= 1.0 / x;
            x += 1.0;
        }
        if (x >= 9.5) {
            r = 1.0 / x;
            y = y + Math.log(x) - 0.5 * r;
            r *= r;
            y -= r * (0.08333333333333333 - r * (0.008333333333333333 - r * (0.003968253968253968 - r * (0.004166666666666667 - r * 0.007575757575757576))));
        }
        return y;
    }
}

