/*
 * Decompiled with CFR 0.152.
 */
package net.librec.job.progress;

import java.util.concurrent.atomic.AtomicBoolean;
import net.librec.job.JobStatus;
import net.librec.job.progress.Progressable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ProgressReporter
implements Progressable,
Runnable {
    private static final Log LOG = LogFactory.getLog(ProgressReporter.class);
    public static final int PROGRESS_INTERVAL = 1;
    private JobStatus jobStatus = new JobStatus();
    private Object lock = new Object();
    private AtomicBoolean taskDone = new AtomicBoolean(false);
    private AtomicBoolean progressFlag = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean sendProgress = this.resetProgressFlag();
        while (!this.taskDone.get()) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.taskDone.get()) {
                        break;
                    }
                    this.lock.wait(1L);
                    sendProgress = true;
                }
                if (!sendProgress) continue;
                this.progressx();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    void setProgressFlag() {
        this.progressFlag.set(true);
    }

    boolean resetProgressFlag() {
        return this.progressFlag.getAndSet(false);
    }

    void setTaskFlag() {
        this.taskDone.set(true);
    }

    boolean resetTaskFlag() {
        return this.taskDone.getAndSet(false);
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void progressx() {
        this.progress();
    }
}

