/*
 * Decompiled with CFR 0.152.
 */
package net.librec.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.data.splitter.LOOCVDataSplitter;
import net.librec.eval.Measure;
import net.librec.eval.RecommenderEvaluator;
import net.librec.filter.RecommendedFilter;
import net.librec.math.algorithm.Randoms;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.similarity.RecommenderSimilarity;
import net.librec.util.DriverClassUtil;
import net.librec.util.FileUtil;
import net.librec.util.JobUtil;
import net.librec.util.ReflectionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecommenderJob {
    protected final Log LOG = LogFactory.getLog(RecommenderJob.class);
    private Configuration conf;
    private DataModel dataModel;
    private Map<String, List<Double>> cvEvalResults;

    public RecommenderJob(Configuration conf) {
        this.conf = conf;
        Long seed = conf.getLong("rec.random.seed");
        if (seed != null) {
            Randoms.seed(seed);
        }
        this.setJobId(JobUtil.generateNewJobId());
    }

    public void runJob() throws LibrecException, ClassNotFoundException, IOException {
        String modelSplit;
        switch (modelSplit = this.conf.get("data.model.splitter")) {
            case "kcv": {
                int cvNumber = this.conf.getInt("data.splitter.cv.number", 1);
                this.cvEvalResults = new HashMap<String, List<Double>>();
                for (int i = 1; i <= cvNumber; ++i) {
                    this.LOG.info("Splitter info: the index of " + modelSplit + " splitter times is " + i);
                    this.conf.set("data.splitter.cv.index", String.valueOf(i));
                    this.executeRecommenderJob();
                }
                this.printCVAverageResult();
                break;
            }
            case "loocv": {
                String loocvType = this.conf.get("data.splitter.loocv");
                if (StringUtils.equals("userdate", loocvType) || StringUtils.equals("itemdate", loocvType)) {
                    this.executeRecommenderJob();
                    break;
                }
                this.cvEvalResults = new HashMap<String, List<Double>>();
                for (int i = 1; i <= this.conf.getInt("data.splitter.cv.number", 1); ++i) {
                    this.LOG.info("Splitter info: the index of " + modelSplit + " splitter times is " + i);
                    this.conf.set("data.splitter.cv.index", String.valueOf(i));
                    this.executeRecommenderJob();
                }
                this.printCVAverageResult();
                break;
            }
            case "testset": {
                this.executeRecommenderJob();
                break;
            }
            case "givenn": {
                this.executeRecommenderJob();
                break;
            }
            case "ratio": {
                this.executeRecommenderJob();
            }
        }
    }

    private void executeRecommenderJob() throws ClassNotFoundException, LibrecException, IOException {
        this.generateDataModel();
        RecommenderContext context = new RecommenderContext(this.conf, this.dataModel);
        this.generateSimilarity(context);
        Recommender recommender = ReflectionUtil.newInstance(this.getRecommenderClass(), this.conf);
        recommender.recommend(context);
        this.executeEvaluator(recommender);
        List<RecommendedItem> recommendedList = recommender.getRecommendedList();
        recommendedList = this.filterResult(recommendedList);
        this.saveResult(recommendedList);
    }

    private void generateDataModel() throws ClassNotFoundException, IOException, LibrecException {
        if (null == this.dataModel) {
            this.dataModel = ReflectionUtil.newInstance(this.getDataModelClass(), this.conf);
        }
        this.dataModel.buildDataModel();
    }

    private void generateSimilarity(RecommenderContext context) {
        String[] similarityKeys = this.conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            for (int i = 0; i < similarityKeys.length; ++i) {
                if (this.getSimilarityClass(i) == null) continue;
                RecommenderSimilarity similarity = ReflectionUtil.newInstance(this.getSimilarityClass(i), this.conf);
                this.conf.set("rec.recommender.similarity.key", similarityKeys[i]);
                similarity.buildSimilarityMatrix(this.dataModel);
                if (similarityKeys[i].equals("item") || similarityKeys[i].equals("user")) {
                    context.setSimilarity(similarity);
                }
                context.addSimilarities(similarityKeys[i], similarity);
            }
        }
    }

    private List<RecommendedItem> filterResult(List<RecommendedItem> recommendedList) throws ClassNotFoundException, IOException {
        if (this.getFilterClass() != null) {
            RecommendedFilter filter = ReflectionUtil.newInstance(this.getFilterClass(), null);
            recommendedList = filter.filter(recommendedList);
        }
        return recommendedList;
    }

    private void executeEvaluator(Recommender recommender) throws ClassNotFoundException, IOException, LibrecException {
        block4: {
            block5: {
                if (!this.conf.getBoolean("rec.eval.enable")) break block4;
                String[] evalClassKeys = this.conf.getStrings("rec.eval.classes");
                if (evalClassKeys == null || evalClassKeys.length <= 0) break block5;
                for (int classIdx = 0; classIdx < evalClassKeys.length; ++classIdx) {
                    RecommenderEvaluator evaluator = ReflectionUtil.newInstance(this.getEvaluatorClass(evalClassKeys[classIdx]), null);
                    evaluator.setTopN(this.conf.getInt("rec.recommender.ranking.topn", 10));
                    evaluator.setDataModel(this.dataModel);
                    double evalValue = recommender.evaluate(evaluator);
                    this.LOG.info("Evaluator info:" + evaluator.getClass().getSimpleName() + " is " + evalValue);
                    this.collectCVResults(evaluator.getClass().getSimpleName(), evalValue);
                }
                break block4;
            }
            Map<Measure.MeasureValue, Double> evalValueMap = recommender.evaluateMap();
            if (evalValueMap == null || evalValueMap.size() <= 0) break block4;
            for (Map.Entry<Measure.MeasureValue, Double> entry : evalValueMap.entrySet()) {
                String evalName = null;
                if (entry == null || entry.getKey() == null) continue;
                if (entry.getKey().getTopN() != null && entry.getKey().getTopN() > 0) {
                    this.LOG.info("Evaluator value:" + (Object)((Object)entry.getKey().getMeasure()) + " top " + entry.getKey().getTopN() + " is " + entry.getValue());
                    evalName = (Object)((Object)entry.getKey().getMeasure()) + " top " + entry.getKey().getTopN();
                } else {
                    this.LOG.info("Evaluator value:" + (Object)((Object)entry.getKey().getMeasure()) + " is " + entry.getValue());
                    evalName = (Object)((Object)entry.getKey().getMeasure()) + "";
                }
                if (null == this.cvEvalResults) continue;
                this.collectCVResults(evalName, entry.getValue());
            }
        }
    }

    public void saveResult(List<RecommendedItem> recommendedList) throws LibrecException, IOException, ClassNotFoundException {
        if (recommendedList != null && recommendedList.size() > 0) {
            String algoSimpleName = DriverClassUtil.getDriverName(this.getRecommenderClass());
            String outputPath = this.conf.get("dfs.result.dir") + "/" + this.conf.get("data.input.path") + "-" + algoSimpleName + "-output/" + algoSimpleName;
            if (null != this.dataModel && (this.dataModel.getDataSplitter() instanceof KCVDataSplitter || this.dataModel.getDataSplitter() instanceof LOOCVDataSplitter) && null != this.conf.getInt("data.splitter.cv.index")) {
                outputPath = outputPath + "-" + String.valueOf(this.conf.getInt("data.splitter.cv.index"));
            }
            this.LOG.info("Result path is " + outputPath);
            StringBuilder sb = new StringBuilder();
            for (RecommendedItem recItem : recommendedList) {
                String userId = recItem.getUserId();
                String itemId = recItem.getItemId();
                String value = String.valueOf(recItem.getValue());
                sb.append(userId).append(",").append(itemId).append(",").append(value).append("\n");
            }
            String resultData = sb.toString();
            try {
                FileUtil.writeString(outputPath, resultData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void printCVAverageResult() {
        this.LOG.info("Average Evaluation Result of Cross Validation:");
        for (Map.Entry<String, List<Double>> entry : this.cvEvalResults.entrySet()) {
            String evalName = entry.getKey();
            List<Double> evalList = entry.getValue();
            double sum = 0.0;
            for (double value : evalList) {
                sum += value;
            }
            double avgEvalResult = sum / (double)evalList.size();
            this.LOG.info("Evaluator value:" + evalName + " is " + avgEvalResult);
        }
    }

    private void collectCVResults(String evalName, Double evalValue) {
        DataSplitter splitter = this.dataModel.getDataSplitter();
        if (splitter != null && (splitter instanceof KCVDataSplitter || splitter instanceof LOOCVDataSplitter)) {
            if (this.cvEvalResults.containsKey(evalName)) {
                this.cvEvalResults.get(evalName).add(evalValue);
            } else {
                ArrayList<Double> newList = new ArrayList<Double>();
                newList.add(evalValue);
                this.cvEvalResults.put(evalName, newList);
            }
        }
    }

    private void setJobId(String jobId) {
        this.conf.set("rec.job.id", jobId);
    }

    public void setRecommenderClass(String jobClass) {
        this.conf.set("rec.recommender.class", jobClass);
    }

    public void setRecommenderClass(Class<Recommender> jobClass) {
        this.conf.set("rec.recommender.class", jobClass.getName());
    }

    public Class<? extends DataModel> getDataModelClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("data.model.format"));
    }

    public Class<? extends RecommenderSimilarity> getSimilarityClass(int i) {
        String[] similarityClassKeys = this.conf.getStrings("rec.similarity.class");
        try {
            if (similarityClassKeys.length >= 2) {
                return DriverClassUtil.getClass(similarityClassKeys[i]);
            }
            return DriverClassUtil.getClass(similarityClassKeys[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Class<? extends Recommender> getRecommenderClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("rec.recommender.class"));
    }

    public Class<? extends RecommenderEvaluator> getEvaluatorClass(String evalClassKey) throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(evalClassKey);
    }

    public Class<? extends RecommendedFilter> getFilterClass() throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(this.conf.get("rec.filter.class"));
    }
}

