/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.rating;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;

public class UnderEstimationUnfairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SparseMatrix userFeatureMatrix;
    protected double underEstimationUnfairness;

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix == null) {
            return 0.0;
        }
        String protectedAttr = "";
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttr = this.conf.get("data.protected.feature");
        }
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numUsers = this.userFeatureMatrix.numRows();
        int numFeatures = this.userFeatureMatrix.numColumns();
        int numItems = testMatrix.numColumns();
        ArrayList<Double> testItemRatingSumByProUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> testProUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> testItemRatingSumByUnproUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> testUnproUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> recItemRatingSumByProUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> recProUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        ArrayList<Double> recItemRatingSumByUnproUsers = new ArrayList<Double>(Collections.nCopies(numItems, 0.0));
        ArrayList<Double> recUnproUsersCounter = new ArrayList<Double>(Collections.nCopies(numItems, 1.0));
        for (int userID = 0; userID < numUsers; ++userID) {
            boolean protectedOrNot = false;
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.userFeatureMatrix.get(userID, featureId) != 1.0) continue;
                protectedOrNot = featureId == (Integer)featureIdMapping.get(protectedAttr);
            }
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            for (int itemId : testSetByUser) {
                double rating = testMatrix.get(userID, itemId);
                if (protectedOrNot) {
                    testItemRatingSumByProUsers.set(itemId, (Double)testItemRatingSumByProUsers.get(itemId) + rating);
                    testProUsersCounter.set(itemId, (Double)testProUsersCounter.get(itemId) + 1.0);
                    continue;
                }
                testItemRatingSumByUnproUsers.set(itemId, (Double)testItemRatingSumByUnproUsers.get(itemId) + rating);
                testUnproUsersCounter.set(itemId, (Double)testUnproUsersCounter.get(itemId) + 1.0);
            }
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemId = recommendListByUser.get(indexOfItem).getKey();
                double ratingPredicted = recommendListByUser.get(indexOfItem).getValue();
                if (protectedOrNot) {
                    recItemRatingSumByProUsers.set(itemId, (Double)recItemRatingSumByProUsers.get(itemId) + ratingPredicted);
                    recProUsersCounter.set(itemId, (Double)recProUsersCounter.get(itemId) + 1.0);
                    continue;
                }
                recItemRatingSumByUnproUsers.set(itemId, (Double)recItemRatingSumByUnproUsers.get(itemId) + ratingPredicted);
                recUnproUsersCounter.set(itemId, (Double)recUnproUsersCounter.get(itemId) + 1.0);
            }
        }
        this.underEstimationUnfairness = 0.0;
        double avgRatingPro = 0.0;
        double avgRecPro = 0.0;
        double avgRatingUnpro = 0.0;
        double avgRecUnpro = 0.0;
        for (int indexOfItem = 0; indexOfItem < numItems; ++indexOfItem) {
            avgRecPro = (Double)recItemRatingSumByProUsers.get(indexOfItem) / (Double)recProUsersCounter.get(indexOfItem);
            avgRatingPro = (Double)testItemRatingSumByProUsers.get(indexOfItem) / (Double)testProUsersCounter.get(indexOfItem);
            avgRecUnpro = (Double)recItemRatingSumByUnproUsers.get(indexOfItem) / (Double)recUnproUsersCounter.get(indexOfItem);
            avgRatingUnpro = (Double)testItemRatingSumByUnproUsers.get(indexOfItem) / (Double)testUnproUsersCounter.get(indexOfItem);
            this.underEstimationUnfairness += Math.abs(Math.max(0.0, avgRatingPro - avgRecPro) - Math.max(0.0, avgRatingUnpro - avgRecUnpro));
        }
        this.underEstimationUnfairness /= (double)numItems;
        return this.underEstimationUnfairness;
    }
}

