/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.rating;

import com.google.common.collect.BiMap;
import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;

public class NonParityUnfairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SparseMatrix userFeatureMatrix;
    protected double nonParityUnfairness;

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix == null) {
            return 0.0;
        }
        String protectedAttr = "";
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttr = this.conf.get("data.protected.feature");
        }
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numUsers = this.userFeatureMatrix.numRows();
        int numFeatures = this.userFeatureMatrix.numColumns();
        this.nonParityUnfairness = 0.0;
        int numUsersPro = 0;
        int numUsersUnpro = 0;
        double predictedRatingPro = 0.0;
        double predictedRatingUnpro = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            boolean protectedOrNot = false;
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.userFeatureMatrix.get(userID, featureId) != 1.0) continue;
                if (featureId == (Integer)featureIdMapping.get(protectedAttr)) {
                    protectedOrNot = true;
                    ++numUsersPro;
                    continue;
                }
                protectedOrNot = false;
                ++numUsersUnpro;
            }
            double userAvgPredictedRating = 0.0;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemId = recommendListByUser.get(indexOfItem).getKey();
                double ratingPredicted = recommendListByUser.get(indexOfItem).getValue();
                userAvgPredictedRating += ratingPredicted;
            }
            userAvgPredictedRating /= (double)topK;
            if (protectedOrNot) {
                predictedRatingPro += userAvgPredictedRating;
                continue;
            }
            predictedRatingUnpro += userAvgPredictedRating;
        }
        this.nonParityUnfairness = Math.abs((predictedRatingPro /= (double)numUsersPro) - (predictedRatingUnpro /= (double)numUsersUnpro));
        return this.nonParityUnfairness;
    }
}

