/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.rating;

import java.util.Iterator;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.RecommendedList;
import net.librec.recommender.item.UserItemRatingEntry;

public class MPEEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix == null) {
            return 0.0;
        }
        int mpeNum = 0;
        int testSize = 0;
        double mpe = this.conf.getDouble("rec.measure.mpe", 0.01);
        Iterator<MatrixEntry> testMatrixIter = testMatrix.iterator();
        Iterator<UserItemRatingEntry> recommendedEntryIter = recommendedList.entryIterator();
        while (testMatrixIter.hasNext()) {
            if (recommendedEntryIter.hasNext()) {
                MatrixEntry testMatrixEntry = testMatrixIter.next();
                UserItemRatingEntry userItemRatingEntry = recommendedEntryIter.next();
                if (testMatrixEntry.row() == userItemRatingEntry.getUserIdx() && testMatrixEntry.column() == userItemRatingEntry.getItemIdx()) {
                    double predictRating;
                    double realRating = testMatrixEntry.get();
                    double error = Math.abs(realRating - (predictRating = userItemRatingEntry.getValue()));
                    if (error > mpe) {
                        ++mpeNum;
                    }
                    ++testSize;
                    continue;
                }
                throw new IndexOutOfBoundsException("index of recommendedList does not equal testMatrix index");
            }
            throw new IndexOutOfBoundsException("index size of recommendedList does not equal testMatrix index size");
        }
        return testSize > 0 ? ((double)mpeNum + 0.0) / (double)testSize : 0.0;
    }
}

