/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.rating;

import java.util.Iterator;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.RecommendedList;
import net.librec.recommender.item.UserItemRatingEntry;

public class MAEEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix == null) {
            return 0.0;
        }
        double mae = 0.0;
        Iterator<MatrixEntry> testMatrixIter = testMatrix.iterator();
        Iterator<UserItemRatingEntry> recommendedEntryIter = recommendedList.entryIterator();
        int testSize = 0;
        while (testMatrixIter.hasNext()) {
            if (recommendedEntryIter.hasNext()) {
                MatrixEntry testMatrixEntry = testMatrixIter.next();
                UserItemRatingEntry userItemRatingEntry = recommendedEntryIter.next();
                if (testMatrixEntry.row() == userItemRatingEntry.getUserIdx() && testMatrixEntry.column() == userItemRatingEntry.getItemIdx()) {
                    double realRating = testMatrixEntry.get();
                    double predictRating = userItemRatingEntry.getValue();
                    mae += Math.abs(realRating - predictRating);
                    ++testSize;
                    continue;
                }
                throw new IndexOutOfBoundsException("index of recommendedList does not equal testMatrix index");
            }
            throw new IndexOutOfBoundsException("index size of recommendedList does not equal testMatrix index size");
        }
        return testSize > 0 ? mae / (double)testSize : 0.0;
    }
}

