/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class ReciprocalRankEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double reciprocalRank = 0.0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testListByUser = testMatrix.getColumnsSet(userID);
            if (testListByUser.size() <= 0) continue;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testListByUser.contains(itemID)) continue;
                reciprocalRank += 1.0 / ((double)indexOfItem + 1.0);
                break;
            }
            ++nonZeroNumUsers;
        }
        return nonZeroNumUsers > 0 ? reciprocalRank / (double)nonZeroNumUsers : 0.0;
    }
}

