/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class RecallEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double totalRecall = 0.0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int numHits = 0;
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int i = 0; i < topK; ++i) {
                int itemID = recommendListByUser.get(i).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                ++numHits;
            }
            totalRecall += (double)numHits / ((double)testSetByUser.size() + 0.0);
            ++nonZeroNumUsers;
        }
        return nonZeroNumUsers > 0 ? totalRecall / (double)nonZeroNumUsers : 0.0;
    }
}

