/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class NoveltyEvaluator
extends AbstractRecommenderEvaluator {
    private SparseMatrix trainMatrix;

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        int numUsers = testMatrix.numRows();
        int numItems = testMatrix.numColumns();
        int[] itemCounts = this.calculatePurchaseCounts(testMatrix, numItems);
        double sumInformation = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            List<ItemEntry<Integer, Double>> recoList = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recoList.size() ? this.topN : recoList.size();
            for (int recoIdx = 0; recoIdx < topK; ++recoIdx) {
                int itemIdx = recoList.get(recoIdx).getKey();
                int count = itemCounts[itemIdx];
                if (count <= 0) continue;
                double estmProbability = (double)count / (double)numUsers;
                double selfInformation = -Math.log(estmProbability);
                sumInformation += selfInformation;
            }
        }
        return sumInformation / ((double)numUsers * Math.log(2.0));
    }

    private int[] calculatePurchaseCounts(SparseMatrix testMatrix, int numItems) {
        int[] itemCounts = new int[numItems];
        for (int itemIdx = 0; itemIdx < numItems; ++itemIdx) {
            itemCounts[itemIdx] = this.trainMatrix.getRows(itemIdx).size() + testMatrix.getRows(itemIdx).size();
        }
        return itemCounts;
    }

    @Override
    public double evaluate(RecommenderContext context, RecommendedList recommendedList) {
        this.trainMatrix = context.getDataModel().getDataSplitter().getTrainData();
        return super.evaluate(context, recommendedList);
    }
}

