/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class NormalizedDCGEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double nDCG = 0.0;
        int maxNumTestItemsByUser = this.conf.getInt("rec.eval.item.test.maxnum", testMatrix.numColumns());
        int idcgsSize = Math.min(maxNumTestItemsByUser, this.topN);
        ArrayList<Double> idcgs = new ArrayList<Double>(idcgsSize + 1);
        idcgs.add(0.0);
        for (int index = 0; index < idcgsSize; ++index) {
            idcgs.add(1.0 / Maths.log(index + 2, 2) + (Double)idcgs.get(index));
        }
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            double dcg = 0.0;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                int rank = indexOfItem + 1;
                dcg += 1.0 / Maths.log(rank + 1, 2);
            }
            nDCG += dcg / (Double)idcgs.get(testSetByUser.size() < topK ? testSetByUser.size() : topK);
            ++nonZeroNumUsers;
        }
        return nonZeroNumUsers > 0 ? nDCG / (double)nonZeroNumUsers : 0.0;
    }
}

