/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class ItemCoverageEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix == null) {
            return 0.0;
        }
        ArrayList<Integer> uniqueItemsRecList = new ArrayList<Integer>();
        ArrayList<Integer> uniqueItemsInTestMatrix = new ArrayList<Integer>();
        int numUsers = testMatrix.numRows();
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            for (int itemID : testSetByUser) {
                if (uniqueItemsInTestMatrix.contains(itemID)) continue;
                uniqueItemsInTestMatrix.add(itemID);
            }
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int recommendItemIdx = recommendListByUser.get(indexOfItem).getKey();
                if (uniqueItemsRecList.contains(recommendItemIdx)) continue;
                uniqueItemsRecList.add(recommendItemIdx);
            }
        }
        return uniqueItemsInTestMatrix.size() > 0 ? (double)uniqueItemsRecList.size() * 1.0 / (double)uniqueItemsInTestMatrix.size() : 0.0;
    }
}

