/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.RecommendedList;

public class IdealDCGEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double iDCG = 0.0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            double idcg = 0.0;
            List<Integer> testListByUser = testMatrix.getColumns(userID);
            if (testListByUser.size() <= 0) continue;
            int numItemsInTestList = testListByUser.size();
            for (int i = 0; i < numItemsInTestList; ++i) {
                idcg += 1.0 / Maths.log((double)i + 2.0, 2);
            }
            iDCG += idcg;
            ++nonZeroNumUsers;
        }
        return nonZeroNumUsers > 0 ? iDCG / (double)nonZeroNumUsers : 0.0;
    }
}

