/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class HitRateEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        if (testMatrix.size() == 0) {
            return 0.0;
        }
        int totalHits = 0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            List<Integer> testListByUser = testMatrix.getColumns(userID);
            if (testListByUser.size() == 1) {
                int itemIdx = testListByUser.get(0);
                List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
                int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
                for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                    int recommendItemIdx = recommendListByUser.get(indexOfItem).getKey();
                    if (recommendItemIdx != itemIdx) continue;
                    ++totalHits;
                    break;
                }
                ++nonZeroNumUsers;
                continue;
            }
            if (testListByUser.size() <= 1) continue;
            throw new IndexOutOfBoundsException("It is not a leave-one-out validation method! Please use leave-one-out validation method");
        }
        return nonZeroNumUsers > 0 ? 1.0 * (double)totalHits / (double)nonZeroNumUsers : 0.0;
    }
}

