/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.List;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;
import net.librec.similarity.RecommenderSimilarity;

public class DiversityByFeaturesEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double totalDiversity = 0.0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        if (this.similarities.containsKey("itemfeature")) {
            SymmMatrix itemSimilarity = ((RecommenderSimilarity)this.similarities.get("itemfeature")).getSimilarityMatrix();
            for (int userID = 0; userID < numUsers; ++userID) {
                List<ItemEntry<Integer, Double>> recommendArrayListByUser = recommendedList.getItemIdxListByUserIdx(userID);
                if (recommendArrayListByUser.size() <= 1) continue;
                double totalDisSimilarityPerUser = 0.0;
                int topK = this.topN <= recommendArrayListByUser.size() ? this.topN : recommendArrayListByUser.size();
                for (int i = 0; i < topK; ++i) {
                    for (int j = 0; j < topK; ++j) {
                        if (i == j) continue;
                        int item1 = recommendArrayListByUser.get(i).getKey();
                        int item2 = recommendArrayListByUser.get(j).getKey();
                        totalDisSimilarityPerUser += 1.0 - itemSimilarity.get(item1, item2);
                    }
                }
                totalDiversity += totalDisSimilarityPerUser * 2.0 / (double)(topK * (topK - 1));
                ++nonZeroNumUsers;
            }
        }
        return nonZeroNumUsers > 0 ? totalDiversity / (double)nonZeroNumUsers : 0.0;
    }
}

