/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class DiscountedProportionalPFairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SparseMatrix itemFeatureMatrix;

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        this.itemFeatureMatrix = this.getDataModel().getFeatureAppender().getItemFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getItemFeatureMap();
        int numItems = this.itemFeatureMatrix.numRows();
        int numFeatures = this.itemFeatureMatrix.numColumns();
        int numUsers = testMatrix.numRows();
        ArrayList<Double> itemFeatureDCGs = new ArrayList<Double>(Collections.nCopies(numFeatures + 1, 0.0));
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            double dcg = 0.0;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                int rank = indexOfItem + 1;
                dcg = 1.0 / Maths.log(rank + 1, 2);
                for (int featureId = 0; featureId < numFeatures; ++featureId) {
                    if (this.itemFeatureMatrix.get(itemID, featureId) != 1.0) continue;
                    itemFeatureDCGs.set(featureId, (Double)itemFeatureDCGs.get(featureId) + dcg);
                }
            }
        }
        double dpf = 0.0;
        for (int featureId = 0; featureId < numFeatures; ++featureId) {
            String f = (String)featureIdMapping.inverse().get(featureId);
            double fDCG = (Double)itemFeatureDCGs.get(featureId);
            System.out.println(f);
            System.out.println(fDCG);
            double sumDCG = 0.0;
            for (int fId = 0; fId < numFeatures; ++fId) {
                sumDCG += ((Double)itemFeatureDCGs.get(fId)).doubleValue();
            }
            dpf += Maths.log(fDCG / sumDCG, 2);
        }
        return dpf;
    }
}

