/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;

public class DiscountedProportionalCFairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SparseMatrix userFeatureMatrix;

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numUsers = this.userFeatureMatrix.numRows();
        int numFeatures = this.userFeatureMatrix.numColumns();
        ArrayList<Double> userFeatureDCGs = new ArrayList<Double>(Collections.nCopies(numFeatures + 1, 0.0));
        String protectedAttribute = "";
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            protectedAttribute = this.conf.get("data.protected.feature");
        }
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            double dcg = 0.0;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                int rank = indexOfItem + 1;
                dcg += 1.0 / Maths.log(rank + 1, 2);
            }
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.userFeatureMatrix.get(userID, featureId) != 1.0) continue;
                if (featureId == (Integer)featureIdMapping.get(protectedAttribute)) {
                    userFeatureDCGs.set(featureId, (Double)userFeatureDCGs.get(featureId) + dcg);
                    continue;
                }
                userFeatureDCGs.set(featureId, (Double)userFeatureDCGs.get(featureId) + dcg);
            }
        }
        double dpf = 0.0;
        for (int featureId = 0; featureId < numFeatures; ++featureId) {
            double fDCG = (Double)userFeatureDCGs.get(featureId);
            double sumDCG = 0.0;
            for (int fId = 0; fId < numFeatures; ++fId) {
                sumDCG += ((Double)userFeatureDCGs.get(fId)).doubleValue();
            }
            dpf += Maths.log(fDCG / sumDCG, 2);
        }
        return dpf;
    }
}

