/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class CalibrationEvaluator
extends AbstractRecommenderEvaluator {
    protected SparseMatrix itemFeatureMatrix;

    private double KullbackLeiblerDivergence(List<Double> interactedDist, List<Double> recommendationDist) {
        double alpha = 0.01;
        double klDiv = 0.0;
        for (int i = 0; i < interactedDist.size(); ++i) {
            if (interactedDist.get(i) == 0.0) continue;
            recommendationDist.set(i, (1.0 - alpha) * recommendationDist.get(i) + alpha * interactedDist.get(i));
            klDiv += interactedDist.get(i) * Maths.log(interactedDist.get(i) / recommendationDist.get(i), 2);
        }
        return klDiv;
    }

    private List<Double> ComputeGenreDistribution(Set<Integer> itemList) {
        this.itemFeatureMatrix = this.getDataModel().getFeatureAppender().getItemFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getItemFeatureMap();
        int numItems = itemList.size();
        int numFeatures = this.itemFeatureMatrix.numColumns();
        ArrayList<Double> featureCount = new ArrayList<Double>(Collections.nCopies(numFeatures, 0.0));
        for (int itemId : itemList) {
            for (int featureId = 0; featureId < numFeatures; ++featureId) {
                if (this.itemFeatureMatrix.get(itemId, featureId) != 1.0) continue;
                featureCount.set(featureId, (Double)featureCount.get(featureId) + 1.0);
            }
        }
        for (int featureId = 0; featureId < numFeatures; ++featureId) {
            featureCount.set(featureId, (Double)featureCount.get(featureId) / (double)itemList.size());
        }
        return featureCount;
    }

    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        int numUsers = testMatrix.numRows();
        double klDivSum = 0.0;
        int nonZeroNumUsers = 0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userID);
            if (testSetByUser.size() <= 0) continue;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userID);
            HashSet<Integer> itemSetByUser = new HashSet<Integer>();
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemIdRecom = recommendListByUser.get(indexOfItem).getKey();
                itemSetByUser.add(itemIdRecom);
            }
            List<Double> p = this.ComputeGenreDistribution(itemSetByUser);
            List<Double> q = this.ComputeGenreDistribution(testSetByUser);
            double klDiv = this.KullbackLeiblerDivergence(p, q);
            klDivSum += klDiv;
            ++nonZeroNumUsers;
        }
        return nonZeroNumUsers > 0 ? klDivSum / (double)nonZeroNumUsers : 0.0;
    }
}

