/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.ranking;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.recommender.item.ItemEntry;
import net.librec.recommender.item.RecommendedList;

public class AUCEvaluator
extends AbstractRecommenderEvaluator {
    @Override
    public double evaluate(SparseMatrix testMatrix, RecommendedList recommendedList) {
        double auc = 0.0;
        int numUsers = testMatrix.numRows();
        int nonZeroNumUsers = 0;
        int[] numDroppedItemsArray = this.getConf().getInts("rec.eval.auc.dropped.num");
        for (int userIdx = 0; userIdx < numUsers; ++userIdx) {
            Set<Integer> testSetByUser = testMatrix.getColumnsSet(userIdx);
            if (testSetByUser.size() <= 0) continue;
            ++nonZeroNumUsers;
            List<ItemEntry<Integer, Double>> recommendListByUser = recommendedList.getItemIdxListByUserIdx(userIdx);
            int numDroppedItems = numDroppedItemsArray[userIdx] - recommendListByUser.size();
            HashSet<Integer> recommendSetByUser = new HashSet<Integer>();
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                recommendSetByUser.add(recommendListByUser.get(indexOfItem).getKey());
            }
            int numRelevantItems = 0;
            int numMissItems = 0;
            for (Integer testItemIdx : testSetByUser) {
                if (recommendSetByUser.contains(testItemIdx)) {
                    ++numRelevantItems;
                    continue;
                }
                ++numMissItems;
            }
            int numEvaluatingItems = recommendSetByUser.size() + numDroppedItems;
            int numEvaluatingPairs = (numEvaluatingItems - numRelevantItems) * numRelevantItems;
            if (numEvaluatingPairs < 0) {
                throw new IndexOutOfBoundsException("numEvaluatingPairs cannot be less than 0.");
            }
            if (numEvaluatingPairs == 0) {
                auc += 0.5;
                continue;
            }
            int numCorrectPairs = 0;
            int hits = 0;
            for (Integer itemIdx : recommendSetByUser) {
                if (!testSetByUser.contains(itemIdx)) {
                    numCorrectPairs += hits;
                    continue;
                }
                ++hits;
            }
            auc += ((double)(numCorrectPairs += hits * (numDroppedItems - numMissItems)) + 0.0) / (double)numEvaluatingPairs;
        }
        return nonZeroNumUsers > 0 ? auc / (double)nonZeroNumUsers : 0.0;
    }
}

