/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval;

import java.util.Map;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.eval.RecommenderEvaluator;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedList;
import net.librec.similarity.RecommenderSimilarity;

public abstract class AbstractRecommenderEvaluator
implements RecommenderEvaluator {
    protected DataModel dataModel;
    protected int topN;
    protected Configuration conf;
    protected SymmMatrix similarityMatrix;
    protected Map<String, RecommenderSimilarity> similarities;

    @Override
    public double evaluate(RecommenderContext context, RecommendedList recommendedList) {
        SparseMatrix testMatrix = context.getDataModel().getDataSplitter().getTestData();
        this.conf = context.getConf();
        String[] similarityKeys = this.conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            this.similarityMatrix = context.getSimilarity().getSimilarityMatrix();
            this.similarities = context.getSimilarities();
        }
        return this.evaluate(testMatrix, recommendedList);
    }

    public abstract double evaluate(SparseMatrix var1, RecommendedList var2);

    @Override
    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModel;
    }
}

