/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.VectorEntry;
import net.librec.util.RatingContext;

public class RatioDataSplitter
extends AbstractDataSplitter {
    private SparseMatrix preferenceMatrix;
    private SparseMatrix datetimeMatrix;

    public RatioDataSplitter() {
    }

    public RatioDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
        this.datetimeMatrix = this.dataConvertor.getDatetimeMatrix();
        String splitter = this.conf.get("data.splitter.ratio");
        switch (splitter.toLowerCase()) {
            case "rating": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByRating(ratio);
                break;
            }
            case "user": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByUser(ratio);
                break;
            }
            case "userfixed": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getFixedRatioByUser(ratio);
                break;
            }
            case "item": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByItem(ratio);
                break;
            }
            case "valid": {
                double trainRatio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                double validationRaito = Double.parseDouble(this.conf.get("data.splitter.validset.ratio"));
                this.getRatio(trainRatio, validationRaito);
                break;
            }
            case "ratingdate": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByRatingDate(ratio);
                break;
            }
            case "userdate": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByUserDate(ratio);
                break;
            }
            case "itemdate": {
                double ratio = Double.parseDouble(this.conf.get("data.splitter.trainset.ratio"));
                this.getRatioByItemDate(ratio);
                break;
            }
        }
    }

    public void getRatioByRating(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            for (MatrixEntry matrixEntry : this.preferenceMatrix) {
                int userIdx = matrixEntry.row();
                int itemIdx = matrixEntry.column();
                double rdm = Randoms.uniform();
                if (rdm < ratio) {
                    this.testMatrix.set(userIdx, itemIdx, 0.0);
                    continue;
                }
                this.trainMatrix.set(userIdx, itemIdx, 0.0);
            }
            SparseMatrix.reshape(this.testMatrix);
            SparseMatrix.reshape(this.trainMatrix);
        }
    }

    public void getRatioByRatingDate(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(this.datetimeMatrix.size());
            for (MatrixEntry me : this.preferenceMatrix) {
                rcs.add(new RatingContext(me.row(), me.column(), (long)this.datetimeMatrix.get(me.row(), me.column())));
            }
            Collections.sort(rcs);
            int trainSize = (int)((double)rcs.size() * ratio);
            for (int i = 0; i < rcs.size(); ++i) {
                RatingContext rc = (RatingContext)rcs.get(i);
                int u = rc.getUser();
                int j = rc.getItem();
                if (i < trainSize) {
                    this.testMatrix.set(u, j, 0.0);
                    continue;
                }
                this.trainMatrix.set(u, j, 0.0);
            }
            rcs = null;
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getRatioByUser(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                List<Integer> items = this.preferenceMatrix.getColumns(u);
                for (int j : items) {
                    if (Randoms.uniform() < ratio) {
                        this.testMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.testMatrix);
            SparseMatrix.reshape(this.trainMatrix);
        }
    }

    public void getFixedRatioByUser(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                List<Integer> items = this.preferenceMatrix.getColumns(u);
                int k = (int)Math.floor((double)items.size() * (1.0 - ratio));
                try {
                    List<Integer> testIndexes = Randoms.randInts(k, 0, items.size());
                    for (int j : items) {
                        if (testIndexes.contains(j)) {
                            this.trainMatrix.set(u, j, 0.0);
                            continue;
                        }
                        this.testMatrix.set(u, j, 0.0);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.LOG.error("This error should not happen because k cannot be outside of the range if ratio is " + ratio);
                }
            }
            SparseMatrix.reshape(this.testMatrix);
            SparseMatrix.reshape(this.trainMatrix);
        }
    }

    public void getRatioByUserDate(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int user = 0; user < um; ++user) {
                List<Integer> unsortedItems = this.preferenceMatrix.getColumns(user);
                int size = unsortedItems.size();
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(size);
                for (int item : unsortedItems) {
                    rcs.add(new RatingContext(user, item, (long)this.datetimeMatrix.get(user, item)));
                }
                Collections.sort(rcs);
                int trainSize = (int)((double)rcs.size() * ratio);
                for (int i = 0; i < rcs.size(); ++i) {
                    RatingContext rc = (RatingContext)rcs.get(i);
                    int u = rc.getUser();
                    int j = rc.getItem();
                    if (i < trainSize) {
                        this.testMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getRatioByItem(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int im = this.preferenceMatrix.numColumns();
            for (int i = 0; i < im; ++i) {
                List<Integer> users = this.preferenceMatrix.getRows(i);
                for (int u : users) {
                    if (Randoms.uniform() < ratio) {
                        this.testMatrix.set(u, i, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, i, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getRatioByItemDate(double ratio) {
        if (ratio > 0.0 && ratio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int im = this.preferenceMatrix.numColumns();
            for (int item = 0; item < im; ++item) {
                List<Integer> unsortedUsers = this.preferenceMatrix.getRows(item);
                int size = unsortedUsers.size();
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(size);
                for (int user : unsortedUsers) {
                    rcs.add(new RatingContext(user, item, (long)this.datetimeMatrix.get(user, item)));
                }
                Collections.sort(rcs);
                int trainSize = (int)((double)rcs.size() * ratio);
                for (int i = 0; i < rcs.size(); ++i) {
                    RatingContext rc = (RatingContext)rcs.get(i);
                    int u = rc.getUser();
                    int j = rc.getItem();
                    if (i < trainSize) {
                        this.testMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.testMatrix);
            SparseMatrix.reshape(this.trainMatrix);
        }
    }

    public void getRatio(double trainRatio, double validationRatio) {
        if (trainRatio > 0.0 && validationRatio > 0.0 && trainRatio + validationRatio < 1.0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.validationMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                SparseVector uv = this.preferenceMatrix.row(u);
                for (VectorEntry j : uv) {
                    double rdm = Randoms.uniform();
                    if (rdm < trainRatio) {
                        this.validationMatrix.set(u, j.index(), 0.0);
                        this.testMatrix.set(u, j.index(), 0.0);
                        continue;
                    }
                    if (rdm < trainRatio + validationRatio) {
                        this.trainMatrix.set(u, j.index(), 0.0);
                        this.testMatrix.set(u, j.index(), 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j.index(), 0.0);
                    this.validationMatrix.set(u, j.index(), 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.validationMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }
}

