/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.SparseMatrix;
import net.librec.util.RatingContext;

public class LOOCVDataSplitter
extends AbstractDataSplitter {
    private SparseMatrix preferenceMatrix;
    private SparseMatrix datetimeMatrix;
    private KCVDataSplitter kcv;

    public LOOCVDataSplitter() {
    }

    public LOOCVDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
        this.datetimeMatrix = this.dataConvertor.getDatetimeMatrix();
        String splitter = this.conf.get("data.splitter.loocv");
        switch (splitter.toLowerCase()) {
            case "user": {
                this.getLOOByUser();
                break;
            }
            case "item": {
                this.getLOOByItems();
                break;
            }
            case "userdate": {
                this.getLOOByUserDate();
                break;
            }
            case "itemdate": {
                this.getLooByItemsDate();
                break;
            }
            case "rate": {
                if (null == this.kcv) {
                    this.conf.setInt("data.splitter.cv.number", this.dataConvertor.getPreferenceMatrix().size());
                    this.kcv = new KCVDataSplitter(this.dataConvertor, this.conf);
                    this.kcv.splitFolds();
                }
                this.kcv.splitData();
                this.trainMatrix = this.kcv.getTrainData();
                this.testMatrix = this.kcv.getTestData();
            }
        }
    }

    public void getLOOByUser() {
        this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int um = this.preferenceMatrix.numRows();
        for (int u = 0; u < um; ++u) {
            List<Integer> items = this.preferenceMatrix.getColumns(u);
            int randId = (int)((double)items.size() * Randoms.uniform());
            int i = items.get(randId);
            this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
            this.trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.preferenceMatrix.get(u, i));
            colMap.put(i, u);
        }
        SparseMatrix.reshape(this.trainMatrix);
        this.testMatrix = new SparseMatrix(this.preferenceMatrix.numRows(), this.preferenceMatrix.numColumns(), dataTable, colMap);
    }

    public void getLOOByUserDate() {
        this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int um = this.preferenceMatrix.numRows();
        for (int u = 0; u < um; ++u) {
            List<Integer> items = this.preferenceMatrix.getColumns(u);
            int i = -1;
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>();
            for (int j : items) {
                rcs.add(new RatingContext(u, j, (long)this.datetimeMatrix.get(u, j)));
            }
            Collections.sort(rcs);
            i = ((RatingContext)rcs.get(rcs.size() - 1)).getItem();
            this.trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.preferenceMatrix.get(u, i));
            colMap.put(i, u);
        }
        SparseMatrix.reshape(this.trainMatrix);
        this.testMatrix = new SparseMatrix(this.preferenceMatrix.numRows(), this.preferenceMatrix.numColumns(), dataTable, colMap);
    }

    public void getLOOByItems() {
        this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int im = this.preferenceMatrix.numColumns();
        for (int i = 0; i < im; ++i) {
            List<Integer> users = this.preferenceMatrix.getRows(i);
            int randId = (int)((double)users.size() * Randoms.uniform());
            int u = users.get(randId);
            this.trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.preferenceMatrix.get(u, i));
            colMap.put(i, u);
        }
        SparseMatrix.reshape(this.trainMatrix);
        this.testMatrix = new SparseMatrix(this.preferenceMatrix.numRows(), this.preferenceMatrix.numColumns(), dataTable, colMap);
    }

    public void getLooByItemsDate() {
        this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        int im = this.preferenceMatrix.numColumns();
        for (int i = 0; i < im; ++i) {
            List<Integer> users = this.preferenceMatrix.getRows(i);
            int u = -1;
            ArrayList<RatingContext> rcs = new ArrayList<RatingContext>();
            for (int v : users) {
                rcs.add(new RatingContext(v, i, (long)this.datetimeMatrix.get(v, i)));
            }
            Collections.sort(rcs);
            u = ((RatingContext)rcs.get(rcs.size() - 1)).getUser();
            this.trainMatrix.set(u, i, 0.0);
            dataTable.put(u, i, this.preferenceMatrix.get(u, i));
            colMap.put(i, u);
        }
        SparseMatrix.reshape(this.trainMatrix);
        this.testMatrix = new SparseMatrix(this.preferenceMatrix.numRows(), this.preferenceMatrix.numColumns(), dataTable, colMap);
    }

    static enum LOOCVType {
        LOOByUser,
        LOOByItem;

    }
}

