/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.util.Lists;

public class KCVDataSplitter
extends AbstractDataSplitter {
    private SparseMatrix preferenceMatrix;
    private SparseMatrix assignMatrix;
    private int cvNumber;
    private int cvIndex;

    public KCVDataSplitter() {
    }

    public KCVDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    public void splitData(int k) throws LibrecException {
        if (k > 0 || k <= this.cvNumber) {
            this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                SparseVector items = this.preferenceMatrix.row(u);
                for (int j : items.getIndex()) {
                    if (this.assignMatrix.get(u, j) == (double)k) {
                        this.trainMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.testMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void splitFolds() {
        this.cvNumber = this.conf.getInt("data.splitter.cv.number", 5);
        if (null == this.assignMatrix) {
            this.splitFolds(this.cvNumber);
        }
    }

    public void splitFolds(int kFold) {
        this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
        if (kFold > 0) {
            this.assignMatrix = new SparseMatrix(this.preferenceMatrix);
            int numRates = this.preferenceMatrix.getData().length;
            int numFold = kFold > numRates ? numRates : kFold;
            ArrayList rdm = new ArrayList(numRates);
            double indvCount = ((double)numRates + 0.0) / (double)numFold;
            for (int i = 0; i < numRates; ++i) {
                rdm.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>((int)((double)i / indvCount) + 1, Randoms.uniform()));
            }
            int[] fold = new int[numRates];
            Lists.sortList(rdm, true);
            for (int index = 0; index < numRates; ++index) {
                fold[index] = (Integer)((Map.Entry)rdm.get(index)).getKey();
            }
            int[] row_ptr = this.preferenceMatrix.getRowPointers();
            int[] col_idx = this.preferenceMatrix.getColumnIndices();
            int i = 0;
            int numUser = this.preferenceMatrix.numRows();
            for (int userIdx = 0; userIdx < numUser; ++userIdx) {
                int end = row_ptr[userIdx + 1];
                for (int idx = row_ptr[userIdx]; idx < end; ++idx) {
                    int itemIdx = col_idx[idx];
                    this.assignMatrix.set(userIdx, itemIdx, fold[i++]);
                }
            }
        }
    }

    @Override
    public void splitData() throws LibrecException {
        this.cvIndex = this.conf.getInt("data.splitter.cv.index");
        this.splitData(this.cvIndex);
    }
}

