/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.convertor.AbstractDataConvertor;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseVector;
import net.librec.math.structure.VectorEntry;

public class GivenTestSetDataSplitter
extends AbstractDataSplitter {
    private SparseMatrix preferenceMatrix;

    public GivenTestSetDataSplitter() {
    }

    public GivenTestSetDataSplitter(DataConvertor convertor, Configuration conf) {
        this.dataConvertor = convertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        AbstractDataConvertor testConvertor = null;
        String dataFormat = this.conf.get("data.model.format");
        switch (dataFormat.toLowerCase()) {
            case "text": {
                this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
                this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
                this.testMatrix = new SparseMatrix(this.preferenceMatrix);
                testConvertor = new TextDataConvertor(this.conf.get("data.column.format", "UIR"), this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.testset.path"), this.conf.getDouble("data.convert.binarize.threshold", -1.0), ((TextDataConvertor)this.dataConvertor).getUserIds(), ((TextDataConvertor)this.dataConvertor).getItemIds());
                try {
                    testConvertor.processData();
                }
                catch (IOException e) {
                    throw new LibrecException(e);
                }
                int um = this.preferenceMatrix.numRows();
                for (int u = 0; u < um; ++u) {
                    SparseVector uv = this.preferenceMatrix.row(u);
                    for (VectorEntry j : uv) {
                        if (testConvertor.getPreferenceMatrix().get(u, j.index()) == 0.0) {
                            this.testMatrix.set(u, j.index(), 0.0);
                            continue;
                        }
                        this.trainMatrix.set(u, j.index(), 0.0);
                    }
                }
                SparseMatrix.reshape(this.trainMatrix);
                SparseMatrix.reshape(this.testMatrix);
                break;
            }
            case "arff": {
                testConvertor = new ArffDataConvertor(this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.testset.path"), ((ArffDataConvertor)this.dataConvertor).getAllFeatureIds());
                try {
                    testConvertor.processData();
                }
                catch (IOException e) {
                    throw new LibrecException(e);
                }
                this.testMatrix = testConvertor.getSparseTensor().rateMatrix();
            }
        }
    }
}

