/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.SparseMatrix;
import net.librec.util.Lists;
import net.librec.util.RatingContext;

public class GivenNDataSplitter
extends AbstractDataSplitter {
    private SparseMatrix preferenceMatrix;
    private SparseMatrix datetimeMatrix;

    public GivenNDataSplitter() {
    }

    public GivenNDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
        this.datetimeMatrix = this.dataConvertor.getDatetimeMatrix();
        String splitter = this.conf.get("data.splitter.givenn");
        switch (splitter.toLowerCase()) {
            case "user": {
                try {
                    this.getGivenNByUser(Integer.parseInt(this.conf.get("data.splitter.givenn.n")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "item": {
                try {
                    this.getGivenNByItem(Integer.parseInt(this.conf.get("data.splitter.givenn.n")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "userdate": {
                try {
                    this.getGivenNByUserDate(Integer.parseInt(this.conf.get("data.splitter.givenn.n")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "itemdate": {
                try {
                    this.getGivenNByItemDate(Integer.parseInt(this.conf.get("data.splitter.givenn.n")));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void getGivenNByUser(int numGiven) throws Exception {
        if (numGiven > 0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                List<Integer> items = this.preferenceMatrix.getColumns(u);
                int numRated = items.size();
                if (numRated > numGiven) {
                    int[] givenIndex = Randoms.nextIntArray(numGiven, numRated);
                    int i = 0;
                    for (int j = 0; j < numRated; ++j) {
                        if (i < givenIndex.length && givenIndex[i] == j) {
                            this.testMatrix.set(u, items.get(j), 0.0);
                            ++i;
                            continue;
                        }
                        this.trainMatrix.set(u, items.get(j), 0.0);
                    }
                    continue;
                }
                for (int j : items) {
                    this.testMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getGivenNByUserDate(int numGiven) {
        if (numGiven > 0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int um = this.preferenceMatrix.numRows();
            for (int u = 0; u < um; ++u) {
                List<Integer> items = this.preferenceMatrix.getColumns(u);
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(Lists.initSize(items.size()));
                for (int j : items) {
                    rcs.add(new RatingContext(u, j, (long)this.datetimeMatrix.get(u, j)));
                }
                Collections.sort(rcs);
                for (int i = 0; i < rcs.size(); ++i) {
                    RatingContext rc = (RatingContext)rcs.get(i);
                    int j = rc.getItem();
                    if (i < numGiven) {
                        this.testMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getGivenNByItem(int numGiven) throws Exception {
        if (numGiven > 0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int jm = this.preferenceMatrix.numColumns();
            for (int j = 0; j < jm; ++j) {
                List<Integer> users = this.preferenceMatrix.getRows(j);
                int numRated = users.size();
                if (numRated > numGiven) {
                    int[] givenIndex = Randoms.nextIntArray(numGiven, numRated);
                    int i = 0;
                    for (int k = 0; k < numRated; ++k) {
                        if (i < givenIndex.length && givenIndex[i] == k) {
                            this.testMatrix.set(users.get(k), j, 0.0);
                            ++i;
                            continue;
                        }
                        this.trainMatrix.set(users.get(k), j, 0.0);
                    }
                    continue;
                }
                for (int u : users) {
                    this.testMatrix.set(u, j, 0.0);
                }
            }
            SparseMatrix.reshape(this.trainMatrix);
            SparseMatrix.reshape(this.testMatrix);
        }
    }

    public void getGivenNByItemDate(int numGiven) {
        if (numGiven > 0) {
            this.trainMatrix = new SparseMatrix(this.preferenceMatrix);
            this.testMatrix = new SparseMatrix(this.preferenceMatrix);
            int jm = this.preferenceMatrix.numRows();
            for (int j = 0; j < jm; ++j) {
                List<Integer> users = this.preferenceMatrix.getRows(j);
                ArrayList<RatingContext> rcs = new ArrayList<RatingContext>(Lists.initSize(users.size()));
                for (int u : users) {
                    rcs.add(new RatingContext(u, j, (long)this.datetimeMatrix.get(u, j)));
                }
                Collections.sort(rcs);
                for (int i = 0; i < rcs.size(); ++i) {
                    RatingContext rc = (RatingContext)rcs.get(i);
                    int u = rc.getUser();
                    if (i < numGiven) {
                        this.testMatrix.set(u, j, 0.0);
                        continue;
                    }
                    this.trainMatrix.set(u, j, 0.0);
                }
                SparseMatrix.reshape(this.trainMatrix);
                SparseMatrix.reshape(this.testMatrix);
            }
        }
    }
}

