/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import com.google.common.collect.BiMap;
import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.data.model.AbstractDataModel;
import net.librec.math.structure.DataSet;
import org.apache.commons.lang.StringUtils;

public class TextDataModel
extends AbstractDataModel
implements DataModel {
    public TextDataModel() {
    }

    public TextDataModel(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void buildConvert() throws LibrecException {
        Object[] inputDataPath = this.conf.get("data.input.path").trim().split(" ");
        for (int i = 0; i < inputDataPath.length; ++i) {
            inputDataPath[i] = this.conf.get("dfs.data.dir") + "/" + (String)inputDataPath[i];
        }
        String dataColumnFormat = this.conf.get("data.column.format", "UIR");
        this.dataConvertor = new TextDataConvertor(dataColumnFormat, StringUtils.join(inputDataPath, " "), this.conf.getDouble("data.convert.binarize.threshold", -1.0));
        try {
            this.dataConvertor.processData();
        }
        catch (IOException e) {
            throw new LibrecException(e);
        }
    }

    @Override
    public void loadDataModel() throws LibrecException {
    }

    @Override
    public void saveDataModel() throws LibrecException {
    }

    @Override
    public BiMap<String, Integer> getUserMappingData() {
        return ((TextDataConvertor)this.dataConvertor).getUserIds();
    }

    @Override
    public BiMap<String, Integer> getItemMappingData() {
        return ((TextDataConvertor)this.dataConvertor).getItemIds();
    }

    @Override
    public DataSet getDatetimeDataSet() {
        return ((TextDataConvertor)this.dataConvertor).getDatetimeMatrix();
    }
}

