/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.librec.common.LibrecException;
import net.librec.data.model.ArffAttribute;

public class ArffInstance {
    public static ArrayList<ArffAttribute> attrs;
    private ArrayList<String> instanceData;

    public ArffInstance(ArrayList<String> instanceData) {
        this.instanceData = instanceData;
    }

    public Object getValueByAttrName(String attrName) throws LibrecException {
        Object res = null;
        boolean isNameValid = false;
        for (ArffAttribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            res = this.getValueByIndex(attr.getIndex());
            isNameValid = true;
            break;
        }
        if (!isNameValid) {
            throw new LibrecException("invalid attrName: " + attrName);
        }
        return res;
    }

    public Object getValueByIndex(int idx) {
        ArrayList<String> res = new ArrayList<String>();
        switch (this.getTypeByIndex(idx).toUpperCase()) {
            case "NUMERIC": 
            case "REAL": 
            case "INTEGER": {
                res = Double.parseDouble(this.instanceData.get(idx));
                break;
            }
            case "STRING": {
                res = this.instanceData.get(idx);
                break;
            }
            case "NOMINAL": {
                String[] data = this.instanceData.get(idx).split(",");
                res = new ArrayList<String>(Arrays.asList(data));
            }
        }
        return res;
    }

    public String getTypeByIndex(int idx) {
        ArffAttribute attr = attrs.get(idx);
        return attr.getType();
    }
}

