/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.DataSplitter;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.model.AbstractDataModel;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SparseMatrix;
import net.librec.math.structure.SparseTensor;
import net.librec.util.DriverClassUtil;
import net.librec.util.ReflectionUtil;

public class ArffDataModel
extends AbstractDataModel
implements DataModel {
    public ArffDataModel() {
    }

    public ArffDataModel(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void buildConvert() throws LibrecException {
        String splitter = this.conf.get("data.model.splitter");
        String dfsDataDir = this.conf.get("dfs.data.dir");
        String inputDataPath = dfsDataDir + "/" + this.conf.get("data.input.path");
        this.dataConvertor = new ArffDataConvertor(inputDataPath);
        try {
            this.dataConvertor.processData();
            this.dataSplitter = (DataSplitter)ReflectionUtil.newInstance(DriverClassUtil.getClass(splitter), this.conf);
        }
        catch (IOException e) {
            throw new LibrecException(e);
        }
        catch (ClassNotFoundException e) {
            throw new LibrecException(e);
        }
    }

    @Override
    protected void buildSplitter() throws LibrecException {
        super.buildSplitter();
        if (this.dataConvertor != null && this.dataSplitter != null) {
            SparseTensor totalTensor = this.dataConvertor.getSparseTensor();
            SparseMatrix testMatrix = this.dataSplitter.getTestData();
            SparseTensor trainTensor = totalTensor.clone();
            int[] dimensions = trainTensor.dimensions();
            SparseTensor testTensor = new SparseTensor(dimensions);
            testTensor.setUserDimension(trainTensor.getUserDimension());
            testTensor.setItemDimension(trainTensor.getItemDimension());
            for (MatrixEntry me : testMatrix) {
                int u = me.row();
                int i = me.column();
                List<Integer> indices = totalTensor.getIndices(u, i);
                for (int index : indices) {
                    int[] keys = totalTensor.keys(index);
                    try {
                        testTensor.set(totalTensor.value(index), keys);
                        trainTensor.remove(keys);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.trainDataSet = trainTensor;
            this.testDataSet = testTensor;
        }
    }

    @Override
    public BiMap<String, Integer> getUserMappingData() {
        return ((ArffDataConvertor)this.dataConvertor).getUserIds();
    }

    @Override
    public BiMap<String, Integer> getItemMappingData() {
        return ((ArffDataConvertor)this.dataConvertor).getItemIds();
    }

    @Override
    public DataSet getDatetimeDataSet() {
        return null;
    }

    public ArrayList<BiMap<String, Integer>> getAllFeaturesMappingData() {
        return ((ArffDataConvertor)this.dataConvertor).getAllFeatureIds();
    }
}

